package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.mixin.PlayerListHudAccessor;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.macro.KillerBot;
import dev.greencat.shimmer.module.modules.macro.Nuker;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.player.rotation.RotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_640;

public class AutoHOTM extends Module {
  public AutoHOTM() {
    super("AutoHOTM", "Do Heart of the Mountains mission automaticly", -1, Module.Category.MACRO);
    this.needDisable = true;
  }
  
  private static final Random random = new Random();
  
  private static final Timer timer = new Timer();
  
  private static class_2338 pos = new class_2338(0, 0, 0);
  
  private static final String CLIFFSIDE_VEINS = "Cliffside Veins";
  
  private static final String LAVA_SPRINGS = "Lava Springs";
  
  private static final String RAMPARTS_QUARRY = "Rampart's Quarry";
  
  private static final String ROYAL_MINES = "Royal Mines";
  
  private static final String UPPER_MINES = "Upper Mines";
  
  private static final String SLAYER_GLACIAL = "Glacite Walker Slayer";
  
  private static final String SLAYER_GOBLIN = "Goblin Slayer";
  
  private static final String TITANIUM_COMMISSION = "Titanium";
  
  private static final String MITHRIL_COMMISSION = "Mithril";
  
  private static final class_2338[] CLIFFSIDE_VEINS_POS = new class_2338[] { new class_2338(47, 135, 11), new class_2338(30, 133, 22), new class_2338(47, 126, 23), new class_2338(11, 127, 36) };
  
  private static final class_2338[] LAVA_SPRINGS_POS = new class_2338[] { new class_2338(46, 210, 17), new class_2338(51, 206, 17) };
  
  private static final class_2338[] RAMPARTS_QUARRY_POS = new class_2338[] { new class_2338(-42, 136, 3), new class_2338(-48, 135, 24), new class_2338(-90, 145, -4), new class_2338(-90, 147, -14) };
  
  private static final class_2338[] ROYAL_MINES_POS = new class_2338[] { new class_2338(140, 152, 24), new class_2338(117, 153, 44) };
  
  private static final class_2338[] UPPER_MINES_POS = new class_2338[] { new class_2338(-126, 172, -76) };
  
  private static final class_2338 GREAT_ICE_WALL_POS = new class_2338(0, 128, 160);
  
  private static final class_2338 GOBLIN_POS = new class_2338(-138, 144, 134);
  
  private static final class_2338 SUBMIT_POS = new class_2338(42, 133, 21);
  
  private static int currentStatus = 0;
  
  private static long lastSwitchStatus = 0L;
  
  private static int clickTick = 0;
  
  private static int READY_GO_SPOT = 0;
  
  private static int READY_MINE = 1;
  
  private static int READY_GO_FORGE = 2;
  
  private static int READY_GO_SUBMIT = 3;
  
  private static int SUBMIT_FINISH = 4;
  
  private static final List<Pattern> COMMISSIONS;
  
  static {
    COMMISSIONS = Stream.<String>of(new String[] { "(?:Titanium|Mithril|Hard Stone) Miner", "(?:Glacite Walker|Golden Goblin|(?<!Golden )Goblin|Goblin Raid|Treasure Hoarder|Automaton|Sludge|Team Treasurite Member|Yog|Boss Corleone|Thyst|Maniac|Mines) Slayer", "(?:Lava Springs|Cliffside Veins|Rampart's Quarry|Upper Mines|Royal Mines) Mithril", "(?:Lava Springs|Cliffside Veins|Rampart's Quarry|Upper Mines|Royal Mines) Titanium" }).map(s -> Pattern.compile("(" + s + "): (\\d+\\.?\\d*%|DONE)")).toList();
  }
  
  @ShimmerSubscribe
  public void onClientTick(TickEvent events) {
    String currentCommission = null;
    for (class_640 playerListEntry : class_310.method_1551().method_1562().method_2880().stream().sorted(PlayerListHudAccessor.getOrdering()).toList()) {
      if (playerListEntry.method_2971() == null)
        continue; 
      String name = playerListEntry.method_2971().getString().strip();
      for (Pattern pattern : COMMISSIONS) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
          String temp = matcher.group(0);
          if (!temp.contains("Raid") && !temp.contains("Golden") && !temp.contains("Powder"))
            currentCommission = temp; 
        } 
      } 
    } 
    if (currentCommission != null && currentStatus == READY_GO_SPOT && !WalkerUtils.isActive() && System.currentTimeMillis() - lastSwitchStatus >= 500L) {
      Shimmer.getInstance().getModuleManager().getModule("KillerBot").setEnabled(false);
      Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(false);
      Shimmer.getInstance().getModuleManager().getModule("Nuker").setEnabled(false);
      ((Nuker)Shimmer.getInstance().getModuleManager().getModule("Nuker")).mode.setMode("Mithril With Titanium");
      if (currentCommission.contains("Cliffside Veins"))
        pos = CLIFFSIDE_VEINS_POS[random.nextInt(CLIFFSIDE_VEINS_POS.length)]; 
      if (currentCommission.contains("Lava Springs"))
        pos = LAVA_SPRINGS_POS[random.nextInt(LAVA_SPRINGS_POS.length)]; 
      if (currentCommission.contains("Rampart's Quarry"))
        pos = RAMPARTS_QUARRY_POS[random.nextInt(RAMPARTS_QUARRY_POS.length)]; 
      if (currentCommission.contains("Royal Mines"))
        pos = ROYAL_MINES_POS[random.nextInt(ROYAL_MINES_POS.length)]; 
      if (currentCommission.contains("Upper Mines"))
        pos = UPPER_MINES_POS[random.nextInt(UPPER_MINES_POS.length)]; 
      if (currentCommission.contains("Glacite Walker Slayer")) {
        pos = GREAT_ICE_WALL_POS;
        ((KillerBot)Shimmer.getInstance().getModuleManager().getModule("KillerBot")).mode.setMode("Glacite Walker");
      } 
      if (currentCommission.contains("Goblin Slayer")) {
        pos = GOBLIN_POS;
        ((KillerBot)Shimmer.getInstance().getModuleManager().getModule("KillerBot")).mode.setMode("Goblin");
      } 
      if ((currentCommission.contains("Titanium") || currentCommission.contains("Mithril")) && currentCommission.contains("Miner")) {
        List<class_2338> posArrayList = new ArrayList<>();
        posArrayList.addAll(List.of(ROYAL_MINES_POS));
        posArrayList.addAll(List.of(RAMPARTS_QUARRY_POS));
        posArrayList.addAll(List.of(CLIFFSIDE_VEINS_POS));
        pos = posArrayList.get(random.nextInt(posArrayList.size()));
      } 
      pos = pos.method_10074();
      WalkerUtils.walkToBaritoneRotation(pos);
      (class_310.method_1551()).field_1724.method_36456((class_310.method_1551()).field_1724.method_36454() + (random.nextInt(100) - 50));
      lastSwitchStatus = System.currentTimeMillis();
      currentStatus = READY_MINE;
    } 
    if (currentStatus == READY_MINE && !WalkerUtils.isActive() && System.currentTimeMillis() - lastSwitchStatus >= 500L && pos != null && (class_310.method_1551()).field_1724.method_24515().method_10262((class_2382)pos) > 5.0D && !currentCommission.contains("DONE")) {
      WalkerUtils.walkToBaritoneRotation(pos);
      (class_310.method_1551()).field_1724.method_36456((class_310.method_1551()).field_1724.method_36454() + (random.nextInt(100) - 50));
    } 
    if (currentStatus == READY_MINE && !WalkerUtils.isActive() && System.currentTimeMillis() - lastSwitchStatus >= 500L && pos != null && (class_310.method_1551()).field_1724.method_24515().method_10262((class_2382)pos) <= 5.0D && !currentCommission.contains("DONE"))
      if (!currentCommission.contains("Slayer")) {
        Shimmer.getInstance().getModuleManager().getModule("Nuker").setEnabled(true);
      } else {
        Shimmer.getInstance().getModuleManager().getModule("KillerBot").setEnabled(true);
      }  
    if (currentStatus == READY_MINE && !WalkerUtils.isActive() && currentCommission != null && currentCommission.contains("DONE")) {
      if (!currentCommission.contains("Slayer")) {
        Shimmer.getInstance().getModuleManager().getModule("Nuker").setEnabled(false);
      } else {
        Shimmer.getInstance().getModuleManager().getModule("KillerBot").setEnabled(false);
        Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(false);
      } 
      (class_310.method_1551()).field_1724.field_3944.method_45731("warp forge");
      lastSwitchStatus = System.currentTimeMillis();
      currentStatus = READY_GO_FORGE;
    } 
    if (currentStatus == READY_GO_FORGE && !Shimmer.getInstance().getModuleManager().getModule("Nuker").isEnabled() && !Shimmer.getInstance().getModuleManager().getModule("KillerBot").isEnabled() && System.currentTimeMillis() - lastSwitchStatus >= 500L) {
      WalkerUtils.walkToBaritoneRotation(SUBMIT_POS);
      (class_310.method_1551()).field_1724.method_36456((class_310.method_1551()).field_1724.method_36454() + (random.nextInt(100) - 50));
      lastSwitchStatus = System.currentTimeMillis();
      currentStatus = READY_GO_SUBMIT;
    } 
    if (currentStatus == READY_GO_SUBMIT && !WalkerUtils.isActive() && System.currentTimeMillis() - lastSwitchStatus >= 500L && (class_310.method_1551()).field_1724.method_24515().method_10262((class_2382)SUBMIT_POS) > 25.0D) {
      WalkerUtils.walkToBaritoneRotation(SUBMIT_POS);
      (class_310.method_1551()).field_1724.method_36456((class_310.method_1551()).field_1724.method_36454() + (random.nextInt(100) - 50));
    } 
    if (currentStatus == READY_GO_SUBMIT && !WalkerUtils.isActive() && System.currentTimeMillis() - lastSwitchStatus >= 500L && (class_310.method_1551()).field_1724.method_24515().method_10262((class_2382)SUBMIT_POS) <= 25.0D)
      if (!((class_310.method_1551()).field_1755 instanceof class_465)) {
        class_1297 submitEntity = null;
        for (class_1297 entity : mc.field_1687.method_18112()) {
          if (entity.method_5845().equals(mc.field_1724.method_5845()))
            continue; 
          if (!(entity instanceof net.minecraft.class_1531))
            continue; 
          if (entity.method_5739((class_1297)(class_310.method_1551()).field_1724) >= 3.0F)
            continue; 
          if (entity.method_16914() && entity.method_5797().getString().contains("CLICK"))
            submitEntity = entity; 
        } 
        if (submitEntity != null) {
          (class_310.method_1551()).field_1724.method_36456((float)RotationUtil.getYaw(submitEntity));
          (class_310.method_1551()).field_1724.method_36457(0.0F);
          lastSwitchStatus = System.currentTimeMillis();
          (class_310.method_1551()).field_1690.field_1904.method_23481(true);
          timer.schedule((TimerTask)new Object(this), 300L);
        } 
        clickTick = 0;
      } else {
        class_465<?> screen = (class_465)mc.field_1755;
        if (screen.method_25440().getString().contains("Commission")) {
          clickTick++;
          if (clickTick == 5)
            mc.field_1761.method_2906((screen.method_17577()).field_7763, 11, 0, class_1713.field_7796, (class_1657)mc.field_1724); 
          if (clickTick == 10)
            mc.field_1761.method_2906((screen.method_17577()).field_7763, 12, 0, class_1713.field_7796, (class_1657)mc.field_1724); 
          if (clickTick == 15)
            mc.field_1761.method_2906((screen.method_17577()).field_7763, 13, 0, class_1713.field_7796, (class_1657)mc.field_1724); 
          if (clickTick == 20)
            mc.field_1761.method_2906((screen.method_17577()).field_7763, 14, 0, class_1713.field_7796, (class_1657)mc.field_1724); 
          if (clickTick == 25)
            mc.field_1761.method_2906((screen.method_17577()).field_7763, 15, 0, class_1713.field_7796, (class_1657)mc.field_1724); 
          if (clickTick > 30) {
            mc.method_1507(null);
            lastSwitchStatus = System.currentTimeMillis();
            currentStatus = SUBMIT_FINISH;
          } 
        } 
      }  
    if (currentStatus == SUBMIT_FINISH && System.currentTimeMillis() - lastSwitchStatus >= 500L && !((class_310.method_1551()).field_1755 instanceof class_465)) {
      (class_310.method_1551()).field_1724.field_3944.method_45731("warp forge");
      lastSwitchStatus = System.currentTimeMillis() + 2000L;
      currentStatus = READY_GO_SPOT;
    } 
  }
  
  public void onDisable() {
    super.onDisable();
    pos = new class_2338(0, 0, 0);
    Shimmer.getInstance().getModuleManager().getModule("Nuker").setEnabled(false);
    Shimmer.getInstance().getModuleManager().getModule("KillerBot").setEnabled(false);
    Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(false);
    WalkerUtils.cancel();
    clickTick = 0;
    currentStatus = READY_GO_SPOT;
  }
}
