package dev.greencat.shimmer.module;

package .tmp;

import dev.greencat.core.type.settings.SettingBase;
import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.render.Hud;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.KeybindSetting;
import dev.greencat.shimmer.util.player.rotation.ServerRotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public abstract class Module {
  public static final class_310 mc = class_310.method_1551();
  
  public String name;
  
  public String description;
  
  public KeybindSetting keyCode = new KeybindSetting(0);
  
  public Category category;
  
  public boolean enabled;
  
  public boolean needDisable = false;
  
  public List<Setting> settings = new ArrayList<>();
  
  public Module(String name, String description, int key, Category category) {
    this(name, description, key, category, false);
  }
  
  public Module(String name, String description, int key, Category category, boolean useServerRotation) {
    this.name = name;
    this.description = description;
    this.keyCode.code = key;
    this.category = category;
    if (useServerRotation)
      ServerRotation.registerServerRotationModule(name); 
    addSettings(new Setting[] { (Setting)this.keyCode });
  }
  
  public void addSettings(Setting... settings) {
    this.settings.addAll(Arrays.asList(settings));
    this.settings.sort(Comparator.comparingInt(s -> (s == this.keyCode) ? 1 : 0));
  }
  
  public void onEnable() {
    Shimmer.getInstance().getEventBus().register(this);
    Shimmer.getInstance().getModuleManager().refreshEnabled();
    class_5250 class_52501 = class_2561.method_43470("Module Manager");
    class_5250 class_52502 = class_2561.method_43470(getName());
    class_5250 class_52503 = class_2561.method_43470(String.valueOf(class_124.field_1060) + "Enabled");
    Hud.onMessage(new class_2561[] { (class_2561)class_52501, (class_2561)class_52502, (class_2561)class_52503 });
  }
  
  public void onDisable() {
    Shimmer.getInstance().getEventBus().unregister(this);
    Shimmer.getInstance().getModuleManager().refreshEnabled();
    class_5250 class_52501 = class_2561.method_43470("Module Manager");
    class_5250 class_52502 = class_2561.method_43470(getName());
    class_5250 class_52503 = class_2561.method_43470(String.valueOf(class_124.field_1061) + "Disabled");
    Hud.onMessage(new class_2561[] { (class_2561)class_52501, (class_2561)class_52502, (class_2561)class_52503 });
  }
  
  public void toggle() {
    this.enabled = !this.enabled;
    if (this.enabled) {
      onEnable();
    } else {
      onDisable();
    } 
    if ((Shimmer.getInstance()).moduleEnabledMap.get(this.name) != null)
      (Shimmer.getInstance()).factory.setValue((SettingBase)(Shimmer.getInstance()).moduleEnabledMap.get(this.name), Boolean.valueOf(this.enabled)); 
  }
  
  public boolean isEnabled() {
    return this.enabled;
  }
  
  public void setEnabled(boolean enabled) {
    if (this.enabled != enabled)
      toggle(); 
  }
  
  public String getName() {
    return this.name;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public Category getCategory() {
    return this.category;
  }
  
  public int getKey() {
    return this.keyCode.code;
  }
  
  public void setKey(int key) {
    this.keyCode.code = key;
  }
}
