package dev.greencat.shimmer.mixin;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.BlockBreakingEvent;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import net.minecraft.class_310;
import net.minecraft.class_542;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_310.class})
public abstract class MinecraftClientMixin {
  @Inject(method = {"<init>"}, at = {@At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;setOverlay(Lnet/minecraft/client/gui/screen/Overlay;)V", shift = At.Shift.BEFORE)})
  private void init(class_542 args, CallbackInfo ci) {
    Shimmer.getInstance().postInitialize();
  }
  
  @Inject(cancellable = true, at = {@At(value = "INVOKE", target = "Lnet/minecraft/util/hit/BlockHitResult;getSide()Lnet/minecraft/util/math/Direction;")}, method = {"handleBlockBreaking"})
  private void HandleBlockBreaking(CallbackInfo ci) {
    BlockBreakingEvent event = new BlockBreakingEvent();
    Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
    if (event.isCancelled())
      ci.cancel(); 
  }
  
  @Inject(method = {"<init>"}, at = {@At("RETURN")})
  public void postApplyModule(class_542 args, CallbackInfo ci) {
    (Shimmer.getInstance().getModuleManager()).enabledModules.sort((o, o1) -> (class_310.method_1551()).field_1772.method_1727(o1) - (class_310.method_1551()).field_1772.method_1727(o));
  }
}
