package dev.greencat.shimmer.mixin;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.LivingEntityRenderPreEvent;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_922.class})
public abstract class LivingEntityRendererMixin<S extends class_10042> {
  @Inject(method = {"render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at = {@At("HEAD")}, cancellable = true)
  public void onRender(S livingEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
    try {
      class_1309 entity = ((class_10042)livingEntityRenderState).field_58171.method_31794().newInstance();
      entity.method_23327(((class_10042)livingEntityRenderState).field_53325, ((class_10042)livingEntityRenderState).field_53326, ((class_10042)livingEntityRenderState).field_53327);
      entity.method_5636(((class_10042)livingEntityRenderState).field_53446);
      entity.method_36457(((class_10042)livingEntityRenderState).field_53448);
      LivingEntityRenderPreEvent event = new LivingEntityRenderPreEvent(entity);
      Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
      if (event.isCancelled())
        ci.cancel(); 
    } catch (Exception exception) {}
  }
}
