package dev.greencat.shimmer.mixin;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.KeyEvent;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.module.Module;
import net.minecraft.class_309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_309.class})
public class KeyboardMixin {
  @Inject(at = {@At(value = "INVOKE", target = "Lnet/minecraft/client/util/InputUtil;isKeyPressed(JI)Z", ordinal = 2)}, method = {"onKey"}, cancellable = true)
  private void onKey(long window, int key, int scanCode, int action, int modifiers, CallbackInfo ci) {
    if (Shimmer.mc.field_1755 != null)
      return; 
    if (action == 2)
      action = 1; 
    if (key != -1) {
      KeyEvent event;
      switch (action) {
        case 0:
          event = new KeyEvent(key, scanCode, KeyEvent.Status.RELEASED);
          Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
          if (event.isCancelled())
            ci.cancel(); 
          break;
        case 1:
          event = new KeyEvent(key, scanCode, KeyEvent.Status.PRESSED);
          Shimmer.getInstance().getModuleManager().getModules().stream().filter(m -> (m.getKey() == key)).forEach(Module::toggle);
          Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
          if (event.isCancelled())
            ci.cancel(); 
          break;
      } 
    } 
  }
}
