package dev.greencat.shimmer.mixin;

package .tmp;

import com.google.common.base.MoreObjects;
import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.ArmRenderEvent;
import dev.greencat.shimmer.event.events.HeldItemRendererEvent;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.module.modules.render.Animation;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_759;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_759.class})
public abstract class HeldItemRendererMixin {
  @Shadow
  private float field_4043;
  
  @Shadow
  private float field_4052;
  
  @Shadow
  private class_1799 field_4047;
  
  @Shadow
  private class_1799 field_4048;
  
  @ModifyVariable(method = {"renderItem(FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/network/ClientPlayerEntity;I)V"}, at = @At(value = "STORE", ordinal = 0), index = 6)
  private float modifySwing(float swingProgress) {
    class_1268 hand = MoreObjects.<class_1268>firstNonNull((class_310.method_1551()).field_1724.field_6266, class_1268.field_5808);
    if (Shimmer.getInstance().getModuleManager().getModule("Animation").isEnabled()) {
      if (hand == class_1268.field_5810 && !(class_310.method_1551()).field_1724.method_6079().method_7960())
        return (float)(swingProgress + Animation.offHandSwingProgress.getValue()); 
      if (hand == class_1268.field_5808 && !(class_310.method_1551()).field_1724.method_6047().method_7960())
        return (float)(swingProgress + Animation.mainHandSwingProgress.getValue()); 
    } 
    return swingProgress;
  }
  
  @ModifyArg(method = {"updateHeldItems"}, at = @At(value = "INVOKE", target = "Lnet/minecraft/util/math/MathHelper;clamp(FFF)F", ordinal = 2), index = 0)
  private float modifyEquipProgressMainhand(float value) {
    if (Shimmer.getInstance().getModuleManager().getModule("Animation").isEnabled()) {
      float f = (class_310.method_1551()).field_1724.method_7261(1.0F);
      float modified = Animation.oldAnimation.isEnabled() ? 1.0F : (f * f * f);
      return ((this.field_4047 == (class_310.method_1551()).field_1724.method_6047()) ? modified : 0.0F) - this.field_4043;
    } 
    return value;
  }
  
  @ModifyArg(method = {"updateHeldItems"}, at = @At(value = "INVOKE", target = "Lnet/minecraft/util/math/MathHelper;clamp(FFF)F", ordinal = 3), index = 0)
  private float modifyEquipProgressOffhand(float value) {
    if (Shimmer.getInstance().getModuleManager().getModule("Animation").isEnabled())
      return ((this.field_4048 == (class_310.method_1551()).field_1724.method_6079()) ? true : false) - this.field_4052; 
    return value;
  }
  
  @Inject(method = {"renderFirstPersonItem"}, at = {@At(value = "INVOKE", target = "Lnet/minecraft/client/render/item/HeldItemRenderer;renderItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemDisplayContext;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V", shift = At.Shift.BEFORE)})
  private void onRenderItem(class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
    Shimmer.getInstance().getEventBus().post((ShimmerEvent)new HeldItemRendererEvent(hand, matrices));
  }
  
  @Inject(method = {"renderFirstPersonItem"}, at = {@At(value = "INVOKE", target = "Lnet/minecraft/client/render/item/HeldItemRenderer;renderArmHoldingItem(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IFFLnet/minecraft/util/Arm;)V")})
  private void onRenderArm(class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
    Shimmer.getInstance().getEventBus().post((ShimmerEvent)new ArmRenderEvent(hand, matrices));
  }
  
  @Inject(method = {"applyEatOrDrinkTransformation"}, at = {@At(value = "INVOKE", target = "Ljava/lang/Math;pow(DD)D", shift = At.Shift.BEFORE)}, cancellable = true)
  private void cancelTransformations(class_4587 matrices, float tickDelta, class_1306 arm, class_1799 stack, class_1657 player, CallbackInfo ci) {
    if (Shimmer.getInstance().getModuleManager().getModule("Animation").isEnabled() && 
      Animation.noFoodAnimation.isEnabled())
      ci.cancel(); 
  }
}
