package dev.greencat.shimmer.mixin;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.PacketEvent;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.irc.IRC;
import dev.greencat.shimmer.util.player.rotation.ServerRotation;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2797;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_2535.class})
public class ClientConnectionMixin {
  @Inject(method = {"channelRead0*"}, at = {@At("HEAD")}, cancellable = true)
  private void packetReceive(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, CallbackInfo ci) {
    PacketEvent event = new PacketEvent(packet, PacketEvent.Type.RECEIVE);
    Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
    if (event.isCancelled())
      ci.cancel(); 
  }
  
  @Inject(method = {"send(Lnet/minecraft/network/packet/Packet;)V"}, at = {@At("HEAD")}, cancellable = true)
  private void packetSend(class_2596<?> packet, CallbackInfo ci) {
    if (packet instanceof class_2797) {
      class_2797 pack = (class_2797)packet;
      if (pack.comp_945().startsWith("!")) {
        if (pack.comp_945().startsWith("!reconnect")) {
          if ((Shimmer.getInstance()).IRC == null) {
            try {
              (Shimmer.getInstance()).IRC = new IRC();
              (Shimmer.getInstance()).IRC.start();
            } catch (Exception e) {
              HaikuLogger.info("[IRC] IRC链接失败");
            } 
          } else {
            HaikuLogger.info("[IRC] IRC已经处于链接状态");
          } 
          ci.cancel();
        } else if (pack.comp_945().startsWith("!disconnect")) {
          Thread thread = new Thread(() -> {
                if ((Shimmer.getInstance()).IRC != null) {
                  try {
                    (Shimmer.getInstance()).IRC.closed = true;
                    (Shimmer.getInstance()).IRC.interrupt();
                    if (!(Shimmer.getInstance()).IRC.socket.isClosed())
                      (Shimmer.getInstance()).IRC.socket.shutdownInput(); 
                    if (!(Shimmer.getInstance()).IRC.socket.isClosed())
                      (Shimmer.getInstance()).IRC.socket.shutdownOutput(); 
                    if (!(Shimmer.getInstance()).IRC.socket.isClosed())
                      (Shimmer.getInstance()).IRC.socket.close(); 
                    HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
                    (Shimmer.getInstance()).IRC = null;
                  } catch (Exception ex) {
                    ex.printStackTrace();
                  } 
                } else {
                  HaikuLogger.info("[IRC] IRC已经处于断开链接状态");
                } 
              });
          thread.start();
          ci.cancel();
        } else if (pack.comp_945().startsWith("!toggle")) {
          if (!(Shimmer.getInstance()).isIRCToggled) {
            HaikuLogger.info("[IRC] IRC现在已经设为默认聊天频道");
            (Shimmer.getInstance()).isIRCToggled = true;
          } else {
            HaikuLogger.info("[IRC] IRC现在已经不再是默认聊天频道");
            (Shimmer.getInstance()).isIRCToggled = false;
          } 
          ci.cancel();
        } else if (pack.comp_945().startsWith("!list")) {
          if ((Shimmer.getInstance()).IRC != null) {
            (Shimmer.getInstance()).IRC.write("#requestPlayerList");
            ci.cancel();
          } 
        } else if ((Shimmer.getInstance()).IRC != null) {
          if (!pack.comp_945().equals("!"))
            (Shimmer.getInstance()).IRC.write(pack.comp_945().substring(1)); 
        } else {
          HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
        } 
        ci.cancel();
      } 
      if (pack.comp_945().startsWith((Shimmer.getInstance().getCommandManager()).prefix)) {
        Shimmer.getInstance().getCommandManager().execute(pack.comp_945());
        ci.cancel();
      } 
      if ((Shimmer.getInstance()).isIRCToggled && !pack.comp_945().startsWith("!")) {
        if ((Shimmer.getInstance()).IRC != null) {
          (Shimmer.getInstance()).IRC.write(pack.comp_945());
        } else {
          HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
        } 
        ci.cancel();
      } 
    } 
    PacketEvent event = new PacketEvent(packet, PacketEvent.Type.SEND);
    Shimmer.getInstance().getEventBus().post((ShimmerEvent)event);
    if (event.isCancelled())
      ci.cancel(); 
    if (!ServerRotation.onPacketSent(packet))
      ci.cancel(); 
  }
}
