package dev.greencat.shimmer.eventbus;

package .tmp;

import dev.greencat.shimmer.eventbus.IEventBus;
import dev.greencat.shimmer.eventbus.Listener;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class EventBus implements IEventBus {
  private final Map<Class<? extends ShimmerEvent>, CopyOnWriteArrayList<Listener>> listeners = new ConcurrentHashMap<>();
  
  public void register(Object registerClass) {
    Arrays.<Method>stream(registerClass.getClass().getMethods())
      .filter(method -> method.isAnnotationPresent((Class)ShimmerSubscribe.class))
      .filter(method -> (method.getParameterCount() == 1))
      .forEach(method -> {
          if (!method.canAccess(registerClass))
            method.setAccessible(true); 
          Class<? extends ShimmerEvent> event = (Class)method.getParameterTypes()[0];
          Consumer<ShimmerEvent> lambda = null;
          if (((ShimmerSubscribe)method.<ShimmerSubscribe>getDeclaredAnnotation(ShimmerSubscribe.class)).lambda())
            lambda = getLambda(registerClass, method, event); 
          if (!this.listeners.containsKey(event))
            this.listeners.put(event, new CopyOnWriteArrayList<>()); 
          ((CopyOnWriteArrayList<Listener>)this.listeners.get(event)).add(new Listener(registerClass, method, lambda));
        });
  }
  
  public void unregister(Object registerClass) {
    this.listeners.values().forEach(arrayList -> arrayList.removeIf(()));
  }
  
  public void post(ShimmerEvent event) {
    List<Listener> listenersList = this.listeners.get(event.getClass());
    if (listenersList != null)
      for (Listener listener : listenersList) {
        if (event.isCancelled())
          return; 
        if (listener.getLambda() != null) {
          listener.getLambda().accept(event);
          continue;
        } 
        try {
          listener.getMethod().invoke(listener.getListenerClass(), new Object[] { event });
        } catch (IllegalAccessException|java.lang.reflect.InvocationTargetException e) {
          e.printStackTrace();
        } 
      }  
  }
  
  protected Consumer<ShimmerEvent> getLambda(Object object, Method method, Class<? extends ShimmerEvent> event) {
    Consumer<ShimmerEvent> eventLambda = null;
    try {
      MethodHandles.Lookup lookup = MethodHandles.lookup();
      MethodType subscription = MethodType.methodType(void.class, event);
      MethodHandle target = lookup.findVirtual(object.getClass(), method.getName(), subscription);
      CallSite site = LambdaMetafactory.metafactory(lookup, "accept", 

          
          MethodType.methodType(Consumer.class, object.getClass()), subscription
          .changeParameterType(0, Object.class), target, subscription);
      MethodHandle factory = site.getTarget();
      eventLambda = factory.bindTo(object).invokeExact();
    } catch (Throwable e) {
      e.printStackTrace();
    } 
    return eventLambda;
  }
}
