package dev.greencat.shimmer;

package .tmp;

import dev.greencat.MaterialConfig;
import dev.greencat.MaterialConfigFactory;
import dev.greencat.core.type.Category;
import dev.greencat.core.type.Module;
import dev.greencat.core.type.settings.BooleanSettings;
import dev.greencat.core.type.settings.KeybindSettings;
import dev.greencat.core.type.settings.ModeSettings;
import dev.greencat.core.type.settings.NumberSettings;
import dev.greencat.core.type.settings.SettingBase;
import dev.greencat.core.type.settings.StringSettings;
import dev.greencat.shimmer.command.CommandManager;
import dev.greencat.shimmer.event.events.ActionBarRenderEvent;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.event.events.WorldChangeEvent;
import dev.greencat.shimmer.eventbus.EventBus;
import dev.greencat.shimmer.eventbus.ShimmerEvent;
import dev.greencat.shimmer.keybind.VanillaKeyBind;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.ModuleManager;
import dev.greencat.shimmer.module.modules.misc.Cat;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.SettingManager;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.KeybindSetting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.setting.settings.StringSetting;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.IconLoader;
import dev.greencat.shimmer.util.RankingOverrider;
import dev.greencat.shimmer.util.irc.IRC;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.player.rotation.SmoothRotation;
import dev.greencat.shimmer.util.render.ShimmerRenderPipelines;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import dev.greencat.shimmer.util.render.animation.AnimationManager;
import dev.greencat.shimmer.util.world.LocationUtils;
import dev.greencat.shimmer.util.world.TPSUtil;
import dev.greencat.utils.color.ColorPalette;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1059;
import net.minecraft.class_10811;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class Shimmer implements ModInitializer {
  public static final String MOD_NAME = "Shimmer Neon";
  
  public static final String MOD_VERSION = "202";
  
  public static final class_310 mc = class_310.method_1551();
  
  public HashMap<String, BooleanSettings> moduleEnabledMap = new HashMap<>();
  
  public boolean lastHasWorld = false;
  
  public boolean isIRCToggled = false;
  
  private static dev.greencat.shimmer.Shimmer INSTANCE;
  
  private final VanillaKeyBind keyBind = new VanillaKeyBind();
  
  private final EventBus EVENT_BUS = new EventBus();
  
  private final ModuleManager MODULE_MANAGER = new ModuleManager();
  
  private final CommandManager COMMAND_MANAGER = new CommandManager();
  
  private final SettingManager SETTING_MANAGER = new SettingManager();
  
  private final RankingOverrider RANKING_OVERRIDER = new RankingOverrider();
  
  public int guiCustomR = 0;
  
  public int guiCustomG = 0;
  
  public int guiCustomB = 0;
  
  public final MaterialConfigFactory factory = new MaterialConfigFactory("Shimmer");
  
  public IRC IRC;
  
  private String title = "Shimmer Neon v202";
  
  public boolean isSorted = false;
  
  private final AnimationManager ANIMATION_MANAGER = new AnimationManager();
  
  public Shimmer() {
    INSTANCE = this;
  }
  
  public static dev.greencat.shimmer.Shimmer getInstance() {
    return INSTANCE;
  }
  
  public void onInitialize() {
    HaikuLogger.logger.info("Shimmer Neon v202 (phase 1) has initialized!");
    WorldRenderEvents.START.register(wrc -> {
          RenderEvent.Pre event = new RenderEvent.Pre(wrc);
          getInstance().getEventBus().post((ShimmerEvent)event);
        });
    WorldRenderEvents.LAST.register(wrc -> {
          RenderEvent.Post event = new RenderEvent.Post(wrc);
          getInstance().getEventBus().post((ShimmerEvent)event);
        });
    WorldRenderEvents.AFTER_ENTITIES.register(wrc -> {
          RenderEvent.AfterEntities event = new RenderEvent.AfterEntities(wrc);
          getInstance().getEventBus().post((ShimmerEvent)event);
        });
    ClientTickEvents.END_CLIENT_TICK.register(client -> {
          if ((class_310.method_1551()).field_1687 != null)
            LocationUtils.update(); 
        });
    ClientReceiveMessageEvents.ALLOW_GAME.register((text, overlay) -> {
          ActionBarRenderEvent event = new ActionBarRenderEvent(text);
          getInstance().getEventBus().post((ShimmerEvent)event);
          return true;
        });
    ClientTickEvents.START_CLIENT_TICK.register(SmoothRotation::onTick);
    ClientTickEvents.START_CLIENT_TICK.register(WalkerUtils::handleRotation);
    ClientTickEvents.START_CLIENT_TICK.register(mc -> {
          if (!this.lastHasWorld && mc.field_1687 != null) {
            HaikuLogger.info("[IRC] IRC已链接,输入\"!disconnect\"断开链接,\"!消息\"发送消息");
            HaikuLogger.info("[IRC] 输入\"!list\"查看当前玩家列表,\"!toggle\"来将IRC设为默认聊天频道");
          } 
          this.lastHasWorld = (mc.field_1687 != null);
        });
    ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
          WorldChangeEvent event = new WorldChangeEvent();
          getInstance().getEventBus().post((ShimmerEvent)event);
        });
    HudRenderCallback.EVENT.register(TextRenderUtil::onRenderHUD);
    WorldRenderEvents.AFTER_ENTITIES.register(context -> {
          if (!LocationUtils.sideBarString.toLowerCase().contains("village"))
            return; 
          class_2680 blockState = class_10811.method_68014(false, true);
          class_1087 blockStateModel = class_310.method_1551().method_1541().method_3349(blockState);
          class_4597 vertexConsumerProvider = context.consumers();
          class_4587 matrixStack = context.matrixStack();
          if (matrixStack == null || vertexConsumerProvider == null)
            return; 
          matrixStack.method_22903();
          class_243 pos = context.camera().method_19326();
          matrixStack.method_22904(-pos.field_1352 + Cat.RENDER_POSITION.field_1352 + 1.0D, -pos.field_1351 + Cat.RENDER_POSITION.field_1351, -pos.field_1350 + Cat.RENDER_POSITION.field_1350 + 1.0D + 0.0125D);
          matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0F));
          class_4587.class_4665 peek = matrixStack.method_23760();
          class_778.method_3367(peek, vertexConsumerProvider.getBuffer(class_1921.method_62290(class_1059.field_5275)), blockStateModel, 1.0F, 1.0F, 1.0F, 15, class_4608.field_21444);
          matrixStack.method_46416(1.0F, 1.0F, 0.0F);
          matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0F));
          Matrix4f matrix4f = peek.method_23761();
          class_4588 cat = vertexConsumerProvider.getBuffer(class_1921.method_23028(Cat.TEXTURE));
          float z = 0.9370117F;
          cat.method_22918(matrix4f, 0.0F, 1.0F, z).method_39415(-1).method_22913(0.0F, 1.0F).method_60803(15);
          cat.method_22918(matrix4f, 1.0F, 1.0F, z).method_39415(-1).method_22913(1.0F, 1.0F).method_60803(15);
          cat.method_22918(matrix4f, 1.0F, 0.0F, z).method_39415(-1).method_22913(1.0F, 0.0F).method_60803(15);
          cat.method_22918(matrix4f, 0.0F, 0.0F, z).method_39415(-1).method_22913(0.0F, 0.0F).method_60803(15);
          matrixStack.method_22909();
          matrixStack.method_22903();
          matrixStack.method_22904(-pos.field_1352 + Cat.BIG_RENDER_POSITION.field_1352 + 1.0D, -pos.field_1351 + Cat.BIG_RENDER_POSITION.field_1351, -pos.field_1350 + Cat.BIG_RENDER_POSITION.field_1350 + 1.0D + 0.0125D);
          matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0F));
          matrixStack.method_22905(7.0F, 7.0F, 1.0F);
          class_4587.class_4665 peek1 = matrixStack.method_23760();
          class_778.method_3367(peek1, vertexConsumerProvider.getBuffer(class_1921.method_62290(class_1059.field_5275)), blockStateModel, 1.0F, 1.0F, 1.0F, 15, class_4608.field_21444);
          matrixStack.method_46416(1.0F, 1.0F, 0.0F);
          matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0F));
          Matrix4f matrix4f1 = peek1.method_23761();
          class_4588 cat1 = vertexConsumerProvider.getBuffer(class_1921.method_23028(Cat.TEXTURE));
          cat1.method_22918(matrix4f1, 0.0F, 1.0F, z).method_39415(-1).method_22913(0.0F, 1.0F).method_60803(15);
          cat1.method_22918(matrix4f1, 1.0F, 1.0F, z).method_39415(-1).method_22913(1.0F, 1.0F).method_60803(15);
          cat1.method_22918(matrix4f1, 1.0F, 0.0F, z).method_39415(-1).method_22913(1.0F, 0.0F).method_60803(15);
          cat1.method_22918(matrix4f1, 0.0F, 0.0F, z).method_39415(-1).method_22913(0.0F, 0.0F).method_60803(15);
          matrixStack.method_22909();
        });
    new ShimmerRenderPipelines();
    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if ((getInstance()).IRC != null)
              try {
                (getInstance()).IRC.socket.close();
                (getInstance()).IRC.reader.close();
                (getInstance()).IRC.writer.close();
              } catch (IOException e) {
                throw new RuntimeException(e);
              }  
          }));
  }
  
  public void postInitialize() {
    this.EVENT_BUS.register(TPSUtil.INSTANCE);
    HaikuLogger.logger.info("Registered TickRateUtil!");
    HaikuLogger.logger.info("Shimmer Neon v202 (phase 2) has initialized!");
    this.MODULE_MANAGER.getModule("AutoFish").setEnabled(false);
    try {
      IconLoader.setWindowIcons(class_310.method_1551().method_22683().method_4490(), new String[] { "/assets/shimmer/logo.png" });
    } catch (Exception e) {
      e.printStackTrace();
      System.err.println("Cannot load icon!");
    } 
    ClientTickEvents.END_CLIENT_TICK.register(client -> {
          if (System.currentTimeMillis() - Cat.lastChange >= 20000L) {
            this.title = "Shimmer Neon v202";
            if (Cat.randomTitle.enabled)
              this.title = this.title + "  |  " + this.title; 
            Cat.lastChange = System.currentTimeMillis();
          } 
          class_310.method_1551().method_22683().method_24286(this.title + " (Minecraft " + this.title + ")");
        });
    try {
      this.IRC = new IRC();
      this.IRC.start();
    } catch (IOException e) {
      e.printStackTrace();
    } 
    for (Module.Category category : Module.Category.values())
      this.factory.addCategory(new Category(category.name())); 
    for (Iterator<Module> iterator = getInstance().getModuleManager().getModules().iterator(); iterator.hasNext(); ) {
      Module module = iterator.next();
      String moduleName = module.getName();
      this.factory.addModule(new Module(module.getCategory().name(), moduleName));
      BooleanSettings booleanSettings = new BooleanSettings(this.factory, moduleName, "isEnabled", false);
      this.factory.addSettings((SettingBase)booleanSettings, value -> module.setEnabled(((Boolean)value.getValue()).booleanValue()));
      this.factory.addCallback((settingBase, value) -> {
            if (settingBase.module.equals(booleanSettings.module) && settingBase.name.equals(booleanSettings.name))
              module.setEnabled(((Boolean)value).booleanValue()); 
          });
      this.moduleEnabledMap.put(moduleName, booleanSettings);
      for (Setting setting : module.settings) {
        BooleanSetting originalSetting;
        BooleanSettings wrapperSetting;
        NumberSetting originalSetting1;
        NumberSettings wrapperSetting1;
        StringSetting originalSetting2;
        StringSettings wrapperSetting2;
        ModeSetting originalSetting3;
        ModeSettings wrapperSetting3;
        KeybindSetting originalSetting4;
        KeybindSettings wrapperSetting4;
        String className = setting.getClass().getSimpleName();
        switch (className) {
          case "BooleanSetting":
            originalSetting = (BooleanSetting)setting;
            wrapperSetting = new BooleanSettings(this.factory, moduleName, originalSetting.name, originalSetting.isEnabled());
            this.factory.addSettings((SettingBase)wrapperSetting, value -> originalSetting.setEnabled(((Boolean)value.getValue()).booleanValue()));
            this.factory.addCallback((settingBase, value) -> {
                  if (settingBase.name.equals(originalSetting.name) && moduleName.equals(settingBase.module))
                    originalSetting.setEnabled(((Boolean)value).booleanValue()); 
                });
            continue;
          case "NumberSetting":
            originalSetting1 = (NumberSetting)setting;
            wrapperSetting1 = new NumberSettings(this.factory, moduleName, originalSetting1.name, Double.valueOf(originalSetting1.getValue()), Double.valueOf(originalSetting1.maximum), Double.valueOf(originalSetting1.minimum));
            this.factory.addSettings((SettingBase)wrapperSetting1, value -> originalSetting1.setValue(((Double)value.getValue()).doubleValue()));
            this.factory.addCallback((settingBase, value) -> {
                  if (settingBase.name.equals(originalSetting1.name) && moduleName.equals(settingBase.module))
                    originalSetting1.setValue(((Double)value).doubleValue()); 
                });
            continue;
          case "StringSetting":
            originalSetting2 = (StringSetting)setting;
            wrapperSetting2 = new StringSettings(this.factory, moduleName, originalSetting2.name, originalSetting2.getString());
            this.factory.addSettings((SettingBase)wrapperSetting2, value -> originalSetting2.setString((String)value.getValue()));
            this.factory.addCallback((settingBase, value) -> {
                  if (settingBase.name.equals(originalSetting2.name) && moduleName.equals(settingBase.module))
                    originalSetting2.setString((String)value); 
                });
            continue;
          case "ModeSetting":
            originalSetting3 = (ModeSetting)setting;
            wrapperSetting3 = new ModeSettings(this.factory, moduleName, originalSetting3.name, originalSetting3.getMode(), (String[])originalSetting3.getModes().toArray((Object[])new String[0]));
            this.factory.addSettings((SettingBase)wrapperSetting3, value -> originalSetting3.setMode((String)value.getValue()));
            this.factory.addCallback((settingBase, value) -> {
                  if (settingBase.name.equals(originalSetting3.name) && moduleName.equals(settingBase.module))
                    originalSetting3.setMode((String)value); 
                });
            continue;
          case "KeybindSetting":
            originalSetting4 = (KeybindSetting)setting;
            wrapperSetting4 = new KeybindSettings(this.factory, moduleName, originalSetting4.name);
            this.factory.addSettings((SettingBase)wrapperSetting4, value -> originalSetting4.setKeyCode(((Integer)value.getValue()).intValue()));
            this.factory.addCallback((settingBase, value) -> {
                  if (settingBase.name.equals(originalSetting4.name) && moduleName.equals(settingBase.module))
                    originalSetting4.setKeyCode(((Integer)value).intValue()); 
                });
            if (module.name.equals("OneGui"))
              wrapperSetting4.setValue(Integer.valueOf(344)); 
            continue;
        } 
        HaikuLogger.logger.error("Unknown setting type: " + className);
      } 
    } 
    NumberSettings backgroundR = new NumberSettings(this.factory, "OneGui", "Background Custom R", Double.valueOf(175.0D), Double.valueOf(255.0D), Double.valueOf(1.0D));
    NumberSettings backgroundG = new NumberSettings(this.factory, "OneGui", "Background Custom G", Double.valueOf(198.0D), Double.valueOf(255.0D), Double.valueOf(1.0D));
    NumberSettings backgroundB = new NumberSettings(this.factory, "OneGui", "Background Custom B", Double.valueOf(255.0D), Double.valueOf(255.0D), Double.valueOf(1.0D));
    NumberSettings backgroundAlpha = new NumberSettings(this.factory, "OneGui", "Background Custom Alpha", Double.valueOf(1.0D), Double.valueOf(1.0D), Double.valueOf(0.0D));
    ModeSettings backgroundDefault = new ModeSettings(this.factory, "OneGui", "Background Color", "Default White", new String[] { "Default White", "Default Dark", "Indigo", "Blue", "Purple", "Teal", "Orange", "Red", "Custom" });
    this.factory.addSettings((SettingBase)backgroundR, value -> this.guiCustomR = ((Double)value.getValue()).intValue());
    this.factory.addSettings((SettingBase)backgroundG, value -> this.guiCustomG = ((Double)value.getValue()).intValue());
    this.factory.addSettings((SettingBase)backgroundB, value -> this.guiCustomB = ((Double)value.getValue()).intValue());
    this.factory.addSettings((SettingBase)backgroundAlpha, value -> MaterialConfig.backgroundAlpha = ((Double)value.getValue()).floatValue());
    this.factory.addCallback((settingBase, value) -> {
          if (settingBase.name.equals(backgroundAlpha.name) && settingBase.module.equals(backgroundAlpha.module))
            MaterialConfig.backgroundAlpha = ((Double)value).floatValue(); 
        });
    this.factory.addCallback((settingBase, value) -> {
          if (settingBase.name.equals(backgroundR.name) && settingBase.module.equals(backgroundR.module)) {
            this.guiCustomR = ((Double)value).intValue();
            if (((String)backgroundDefault.getValue()).equals("Custom"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB)); 
          } 
        });
    this.factory.addCallback((settingBase, value) -> {
          if (settingBase.name.equals(backgroundG.name) && settingBase.module.equals(backgroundG.module)) {
            this.guiCustomG = ((Double)value).intValue();
            if (((String)backgroundDefault.getValue()).equals("Custom"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB)); 
          } 
        });
    this.factory.addCallback((settingBase, value) -> {
          if (settingBase.name.equals(backgroundB.name) && settingBase.module.equals(backgroundB.module)) {
            this.guiCustomB = ((Double)value).intValue();
            if (((String)backgroundDefault.getValue()).equals("Custom"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB)); 
          } 
        });
    this.factory.addSettings((SettingBase)backgroundDefault, value -> {
          String valueStr = (String)value.getValue();
          if (valueStr.equals("Default White"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255)); 
          if (valueStr.equals("Default Dark"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36)); 
          if (valueStr.equals("Indigo"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181)); 
          if (valueStr.equals("Blue"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243)); 
          if (valueStr.equals("Purple"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176)); 
          if (valueStr.equals("Teal"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136)); 
          if (valueStr.equals("Orange"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0)); 
          if (valueStr.equals("Red"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54)); 
          if (valueStr.equals("Custom"))
            MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB)); 
        });
    this.factory.addCallback((settingBase, value) -> {
          if (settingBase.name.equals(backgroundDefault.name) && settingBase.module.equals(backgroundDefault.module)) {
            String valueStr = value.toString();
            if (valueStr.equals("Default White"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255)); 
            if (valueStr.equals("Default Dark"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36)); 
            if (valueStr.equals("Indigo"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181)); 
            if (valueStr.equals("Blue"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243)); 
            if (valueStr.equals("Purple"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176)); 
            if (valueStr.equals("Teal"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136)); 
            if (valueStr.equals("Orange"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0)); 
            if (valueStr.equals("Red"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54)); 
            if (valueStr.equals("Custom"))
              MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB)); 
          } 
        });
  }
  
  public EventBus getEventBus() {
    return this.EVENT_BUS;
  }
  
  public ModuleManager getModuleManager() {
    return this.MODULE_MANAGER;
  }
  
  public CommandManager getCommandManager() {
    return this.COMMAND_MANAGER;
  }
  
  public SettingManager getSettingManager() {
    return this.SETTING_MANAGER;
  }
  
  public VanillaKeyBind getKeyBindManager() {
    return this.keyBind;
  }
}
