package baritone;

package .tmp;

import baritone.a;
import baritone.ab;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.argument.ICommandArgument;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.exception.CommandException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.exception.CommandNotEnoughArgumentsException;
import baritone.api.command.exception.CommandTooManyArgumentsException;
import baritone.api.command.manager.ICommandManager;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;

public final class z implements IArgConsumer {
  final ICommandManager a;
  
  private final a a;
  
  private final LinkedList<ICommandArgument> a;
  
  private final Deque<ICommandArgument> a;
  
  private z(ICommandManager paramICommandManager, Deque<ICommandArgument> paramDeque1, Deque<ICommandArgument> paramDeque2) {
    this.a = (Deque<ICommandArgument>)paramICommandManager;
    this.a = (Deque<ICommandArgument>)new a(this);
    this.a = new LinkedList<>(paramDeque1);
    this.a = new LinkedList<>(paramDeque2);
  }
  
  public z(ICommandManager paramICommandManager, List<ICommandArgument> paramList) {
    this(paramICommandManager, new LinkedList<>(paramList), new LinkedList<>());
  }
  
  public final LinkedList<ICommandArgument> getArgs() {
    return (LinkedList<ICommandArgument>)this.a;
  }
  
  public final Deque<ICommandArgument> getConsumed() {
    return this.a;
  }
  
  public final boolean has(int paramInt) {
    return (this.a.size() >= paramInt);
  }
  
  public final boolean hasAny() {
    return has(1);
  }
  
  public final boolean hasAtMost(int paramInt) {
    return (this.a.size() <= paramInt);
  }
  
  public final boolean hasAtMostOne() {
    return hasAtMost(1);
  }
  
  public final boolean hasExactly(int paramInt) {
    return (this.a.size() == paramInt);
  }
  
  public final boolean hasExactlyOne() {
    return hasExactly(1);
  }
  
  public final ICommandArgument peek(int paramInt) {
    requireMin(paramInt + 1);
    return this.a.get(paramInt);
  }
  
  public final ICommandArgument peek() {
    return peek(0);
  }
  
  public final boolean is(Class<?> paramClass, int paramInt) {
    return peek(paramInt).is(paramClass);
  }
  
  public final boolean is(Class<?> paramClass) {
    return is(paramClass, 0);
  }
  
  public final String peekString(int paramInt) {
    return peek(paramInt).getValue();
  }
  
  public final String peekString() {
    return peekString(0);
  }
  
  public final <E extends Enum<?>> E peekEnum(Class<E> paramClass, int paramInt) {
    return (E)peek(paramInt).getEnum(paramClass);
  }
  
  public final <E extends Enum<?>> E peekEnum(Class<E> paramClass) {
    return peekEnum(paramClass, 0);
  }
  
  public final <E extends Enum<?>> E peekEnumOrNull(Class<E> paramClass, int paramInt) {
    try {
      return peekEnum(paramClass, paramInt);
    } catch (CommandInvalidTypeException commandInvalidTypeException) {
      return null;
    } 
  }
  
  public final <E extends Enum<?>> E peekEnumOrNull(Class<E> paramClass) {
    return peekEnumOrNull(paramClass, 0);
  }
  
  public final <T> T peekAs(Class<T> paramClass, int paramInt) {
    return (T)peek(paramInt).getAs(paramClass);
  }
  
  public final <T> T peekAs(Class<T> paramClass) {
    return peekAs(paramClass, 0);
  }
  
  public final <T> T peekAsOrDefault(Class<T> paramClass, T paramT, int paramInt) {
    try {
      return peekAs(paramClass, paramInt);
    } catch (CommandInvalidTypeException commandInvalidTypeException) {
      return paramT;
    } 
  }
  
  public final <T> T peekAsOrDefault(Class<T> paramClass, T paramT) {
    return peekAsOrDefault(paramClass, paramT, 0);
  }
  
  public final <T> T peekAsOrNull(Class<T> paramClass, int paramInt) {
    return peekAsOrDefault(paramClass, null, paramInt);
  }
  
  public final <T> T peekAsOrNull(Class<T> paramClass) {
    return peekAsOrNull(paramClass, 0);
  }
  
  public final <T> T peekDatatype(IDatatypeFor<T> paramIDatatypeFor) {
    return a().getDatatypeFor(paramIDatatypeFor);
  }
  
  public final <T, O> T peekDatatype(IDatatypePost<T, O> paramIDatatypePost) {
    return peekDatatype(paramIDatatypePost, null);
  }
  
  public final <T, O> T peekDatatype(IDatatypePost<T, O> paramIDatatypePost, O paramO) {
    return a().getDatatypePost(paramIDatatypePost, paramO);
  }
  
  public final <T> T peekDatatypeOrNull(IDatatypeFor<T> paramIDatatypeFor) {
    return a().getDatatypeForOrNull(paramIDatatypeFor);
  }
  
  public final <T, O> T peekDatatypeOrNull(IDatatypePost<T, O> paramIDatatypePost) {
    return a().getDatatypePostOrNull(paramIDatatypePost, null);
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T peekDatatypePost(D paramD, O paramO) {
    return a().getDatatypePost(paramD, paramO);
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T peekDatatypePostOrDefault(D paramD, O paramO, T paramT) {
    return a().getDatatypePostOrDefault(paramD, paramO, paramT);
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T peekDatatypePostOrNull(D paramD, O paramO) {
    return peekDatatypePostOrDefault(paramD, paramO, null);
  }
  
  public final <T, D extends IDatatypeFor<T>> T peekDatatypeFor(Class<D> paramClass) {
    while (true)
      this = a(); 
  }
  
  public final <T, D extends IDatatypeFor<T>> T peekDatatypeForOrDefault(Class<D> paramClass, T paramT) {
    while (true)
      this = a(); 
  }
  
  public final <T, D extends IDatatypeFor<T>> T peekDatatypeForOrNull(Class<D> paramClass) {
    return peekDatatypeForOrDefault(paramClass, null);
  }
  
  public final ICommandArgument get() {
    requireMin(1);
    ICommandArgument iCommandArgument = this.a.removeFirst();
    this.a.add(iCommandArgument);
    return iCommandArgument;
  }
  
  public final String getString() {
    return get().getValue();
  }
  
  public final <E extends Enum<?>> E getEnum(Class<E> paramClass) {
    return (E)get().getEnum(paramClass);
  }
  
  public final <E extends Enum<?>> E getEnumOrDefault(Class<E> paramClass, E paramE) {
    try {
      peekEnum(paramClass);
      return getEnum(paramClass);
    } catch (CommandInvalidTypeException commandInvalidTypeException) {
      return paramE;
    } 
  }
  
  public final <E extends Enum<?>> E getEnumOrNull(Class<E> paramClass) {
    return getEnumOrDefault(paramClass, null);
  }
  
  public final <T> T getAs(Class<T> paramClass) {
    return (T)get().getAs(paramClass);
  }
  
  public final <T> T getAsOrDefault(Class<T> paramClass, T paramT) {
    try {
      Object object = peek().getAs(paramClass);
      get();
      return (T)object;
    } catch (CommandInvalidTypeException commandInvalidTypeException) {
      return paramT;
    } 
  }
  
  public final <T> T getAsOrNull(Class<T> paramClass) {
    return getAsOrDefault(paramClass, null);
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T getDatatypePost(D paramD, O paramO) {
    try {
      return (T)paramD.apply((IDatatypeContext)this.a, paramO);
    } catch (Exception exception) {
      if (((Boolean)(a.a()).verboseCommandExceptions.value).booleanValue())
        exception.printStackTrace(); 
      throw new CommandInvalidTypeException(hasAny() ? peek() : consumed(), paramD.getClass().getSimpleName(), exception);
    } 
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T getDatatypePostOrDefault(D paramD, O paramO, T paramT) {
    ArrayList<ICommandArgument> arrayList1 = new ArrayList<>(this.a);
    ArrayList<ICommandArgument> arrayList2 = new ArrayList<>(this.a);
    try {
      return getDatatypePost(paramD, paramO);
    } catch (Exception exception) {
      this.a.clear();
      this.a.addAll(arrayList1);
      this.a.clear();
      this.a.addAll(arrayList2);
      return paramT;
    } 
  }
  
  public final <T, O, D extends IDatatypePost<T, O>> T getDatatypePostOrNull(D paramD, O paramO) {
    return getDatatypePostOrDefault(paramD, paramO, null);
  }
  
  public final <T, D extends IDatatypeFor<T>> T getDatatypeFor(D paramD) {
    try {
      return (T)paramD.get((IDatatypeContext)this.a);
    } catch (Exception exception) {
      if (((Boolean)(a.a()).verboseCommandExceptions.value).booleanValue())
        exception.printStackTrace(); 
      throw new CommandInvalidTypeException(hasAny() ? peek() : consumed(), paramD.getClass().getSimpleName(), exception);
    } 
  }
  
  public final <T, D extends IDatatypeFor<T>> T getDatatypeForOrDefault(D paramD, T paramT) {
    ArrayList<ICommandArgument> arrayList1 = new ArrayList<>(this.a);
    ArrayList<ICommandArgument> arrayList2 = new ArrayList<>(this.a);
    try {
      return getDatatypeFor(paramD);
    } catch (Exception exception) {
      this.a.clear();
      this.a.addAll(arrayList1);
      this.a.clear();
      this.a.addAll(arrayList2);
      return paramT;
    } 
  }
  
  public final <T, D extends IDatatypeFor<T>> T getDatatypeForOrNull(D paramD) {
    return getDatatypeForOrDefault(paramD, null);
  }
  
  public final <T extends baritone.api.command.datatypes.IDatatype> Stream<String> tabCompleteDatatype(T paramT) {
    try {
      return paramT.tabComplete((IDatatypeContext)this.a);
    } catch (CommandException commandException) {
    
    } catch (Exception exception) {
      null.printStackTrace();
    } 
    return Stream.empty();
  }
  
  public final String rawRest() {
    return (this.a.size() > 0) ? ((ICommandArgument)this.a.getFirst()).getRawRest() : "";
  }
  
  public final void requireMin(int paramInt) {
    if (this.a.size() < paramInt)
      throw new CommandNotEnoughArgumentsException(paramInt + this.a.size()); 
  }
  
  public final void requireMax(int paramInt) {
    if (this.a.size() > paramInt)
      throw new CommandTooManyArgumentsException(paramInt + this.a.size()); 
  }
  
  public final void requireExactly(int paramInt) {
    requireMin(paramInt);
    requireMax(paramInt);
  }
  
  public final boolean hasConsumed() {
    return !this.a.isEmpty();
  }
  
  public final ICommandArgument consumed() {
    return (ICommandArgument)((this.a.size() > 0) ? this.a.getLast() : ab.a());
  }
  
  public final String consumedString() {
    return consumed().getValue();
  }
  
  private baritone.z a() {
    return new baritone.z((ICommandManager)this.a, this.a, this.a);
  }
}
