package baritone;

package .tmp;

import baritone.api.cache.IWaypoint;
import baritone.api.cache.IWaypointCollection;
import baritone.api.cache.Waypoint;
import baritone.api.utils.BetterBlockPos;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class s implements IWaypointCollection {
  private final Path a;
  
  private final Map<IWaypoint.Tag, Set<IWaypoint>> a;
  
  s(Path paramPath) {
    this.a = (Map<IWaypoint.Tag, Set<IWaypoint>>)paramPath;
    if (!Files.exists(paramPath, new java.nio.file.LinkOption[0]))
      try {
        Files.createDirectories(paramPath, (FileAttribute<?>[])new FileAttribute[0]);
      } catch (IOException iOException) {} 
    System.out.println("Would save waypoints to " + String.valueOf(paramPath));
    this.a = new HashMap<>();
    baritone.s s1 = this;
    IWaypoint.Tag[] arrayOfTag;
    int i = (arrayOfTag = IWaypoint.Tag.values()).length;
    for (byte b = 0; b < i; b++) {
      IWaypoint.Tag tag = arrayOfTag[b];
      s1.a(tag);
    } 
  }
  
  private synchronized void a(IWaypoint.Tag paramTag) {
    this.a.put(paramTag, new HashSet<>());
    Path path;
    if (!Files.exists(path = this.a.resolve(paramTag.name().toLowerCase() + ".mp4"), new java.nio.file.LinkOption[0]))
      return; 
    try {
      FileInputStream fileInputStream = new FileInputStream(path.toFile());
      try {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try {
          DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
          try {
            long l1;
            if ((l1 = dataInputStream.readLong()) != 121977993584L)
              throw new IOException("Bad magic value " + l1); 
            long l2 = dataInputStream.readLong();
            while (l2-- > 0L) {
              String str = dataInputStream.readUTF();
              long l = dataInputStream.readLong();
              int i = dataInputStream.readInt();
              int j = dataInputStream.readInt();
              int k = dataInputStream.readInt();
              ((Set<Waypoint>)this.a.get(paramTag)).add(new Waypoint(str, paramTag, new BetterBlockPos(i, j, k), l));
            } 
            dataInputStream.close();
          } catch (Throwable throwable) {
            try {
              dataInputStream.close();
            } catch (Throwable throwable1) {
              throwable.addSuppressed(throwable1);
            } 
            throw throwable;
          } 
          bufferedInputStream.close();
        } catch (Throwable throwable) {
          try {
            bufferedInputStream.close();
          } catch (Throwable throwable1) {
            throwable.addSuppressed(throwable1);
          } 
          throw throwable;
        } 
        fileInputStream.close();
        return;
      } catch (Throwable throwable) {
        try {
          fileInputStream.close();
        } catch (Throwable throwable1) {
          throwable.addSuppressed(throwable1);
        } 
        throw throwable;
      } 
    } catch (IOException iOException) {
      return;
    } 
  }
  
  private synchronized void b(IWaypoint.Tag paramTag) {
    Path path = this.a.resolve(paramTag.name().toLowerCase() + ".mp4");
    try {
      FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());
      try {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
          DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
          try {
            dataOutputStream.writeLong(121977993584L);
            dataOutputStream.writeLong(((Set)this.a.get(paramTag)).size());
            for (IWaypoint iWaypoint : this.a.get(paramTag)) {
              dataOutputStream.writeUTF(iWaypoint.getName());
              dataOutputStream.writeLong(iWaypoint.getCreationTimestamp());
              dataOutputStream.writeInt(iWaypoint.getLocation().u());
              dataOutputStream.writeInt(iWaypoint.getLocation().v());
              dataOutputStream.writeInt(iWaypoint.getLocation().w());
            } 
            dataOutputStream.close();
          } catch (Throwable throwable) {
            try {
              dataOutputStream.close();
            } catch (Throwable throwable1) {
              throwable.addSuppressed(throwable1);
            } 
            throw throwable;
          } 
          bufferedOutputStream.close();
        } catch (Throwable throwable) {
          try {
            bufferedOutputStream.close();
          } catch (Throwable throwable1) {
            throwable.addSuppressed(throwable1);
          } 
          throw throwable;
        } 
        fileOutputStream.close();
        return;
      } catch (Throwable throwable) {
        try {
          fileOutputStream.close();
        } catch (Throwable throwable1) {
          throwable.addSuppressed(throwable1);
        } 
        throw throwable;
      } 
    } catch (IOException iOException) {
      null.printStackTrace();
      return;
    } 
  }
  
  public final void addWaypoint(IWaypoint paramIWaypoint) {
    if (((Set<IWaypoint>)this.a.get(paramIWaypoint.getTag())).add(paramIWaypoint))
      b(paramIWaypoint.getTag()); 
  }
  
  public final void removeWaypoint(IWaypoint paramIWaypoint) {
    if (((Set)this.a.get(paramIWaypoint.getTag())).remove(paramIWaypoint))
      b(paramIWaypoint.getTag()); 
  }
  
  public final IWaypoint getMostRecentByTag(IWaypoint.Tag paramTag) {
    return ((Set<IWaypoint>)this.a.get(paramTag)).stream().min(Comparator.comparingLong(paramIWaypoint -> -paramIWaypoint.getCreationTimestamp())).orElse(null);
  }
  
  public final Set<IWaypoint> getByTag(IWaypoint.Tag paramTag) {
    return Collections.unmodifiableSet(this.a.get(paramTag));
  }
  
  public final Set<IWaypoint> getAllWaypoints() {
    return (Set<IWaypoint>)this.a.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
  }
}
