package baritone.launch.mixins;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.TickEvent;
import baritone.api.event.events.WorldEvent;
import baritone.api.event.events.type.EventState;
import fqq;
import fzo;
import fzq;
import glo;
import gqm;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({fqq.class})
public class MixinMinecraft {
  @Shadow
  public gqm t;
  
  @Shadow
  public glo s;
  
  @Unique
  private BiFunction<EventState, TickEvent.Type, TickEvent> tickProvider;
  
  @Inject(method = {"<init>"}, at = {@At("RETURN")})
  private void postInit(CallbackInfo paramCallbackInfo) {
    BaritoneAPI.getProvider().getPrimaryBaritone();
  }
  
  @Inject(method = {"tick"}, at = {@At(value = "FIELD", opcode = 180, target = "net/minecraft/client/Minecraft.screen:Lnet/minecraft/client/gui/screens/Screen;", ordinal = 0, shift = At.Shift.BEFORE)}, slice = {@Slice(from = @At(value = "FIELD", opcode = 181, target = "net/minecraft/client/Minecraft.missTime:I"))})
  private void runTick(CallbackInfo paramCallbackInfo) {
    this.tickProvider = TickEvent.createNextProvider();
    Iterator<IBaritone> iterator = BaritoneAPI.getProvider().getAllBaritones().iterator();
    while (iterator.hasNext()) {
      IBaritone iBaritone;
      TickEvent.Type type = ((iBaritone = iterator.next()).getPlayerContext().player() != null && iBaritone.getPlayerContext().world() != null) ? TickEvent.Type.IN : TickEvent.Type.OUT;
      iBaritone.getGameEventHandler().onTick(this.tickProvider.apply(EventState.PRE, type));
    } 
  }
  
  @Inject(method = {"tick"}, at = {@At("RETURN")})
  private void postRunTick(CallbackInfo paramCallbackInfo) {
    if (this.tickProvider == null)
      return; 
    Iterator<IBaritone> iterator = BaritoneAPI.getProvider().getAllBaritones().iterator();
    while (iterator.hasNext()) {
      IBaritone iBaritone;
      TickEvent.Type type = ((iBaritone = iterator.next()).getPlayerContext().player() != null && iBaritone.getPlayerContext().world() != null) ? TickEvent.Type.IN : TickEvent.Type.OUT;
      iBaritone.getGameEventHandler().onPostTick(this.tickProvider.apply(EventState.POST, type));
    } 
    this.tickProvider = null;
  }
  
  @Inject(method = {"tick"}, at = {@At(value = "INVOKE", target = "net/minecraft/client/multiplayer/ClientLevel.tickEntities()V", shift = At.Shift.AFTER)})
  private void postUpdateEntities(CallbackInfo paramCallbackInfo) {
    IBaritone iBaritone;
    if ((iBaritone = BaritoneAPI.getProvider().getBaritoneForPlayer(this.t)) != null)
      iBaritone.getGameEventHandler().onPlayerUpdate(new PlayerUpdateEvent(EventState.POST)); 
  }
  
  @Inject(method = {"setLevel"}, at = {@At("HEAD")})
  private void preLoadWorld(glo paramglo, fzo.a parama, CallbackInfo paramCallbackInfo) {
    if (this.s == null && paramglo == null)
      return; 
    BaritoneAPI.getProvider().getPrimaryBaritone().getGameEventHandler().onWorldEvent(new WorldEvent(paramglo, EventState.PRE));
  }
  
  @Inject(method = {"setLevel"}, at = {@At("RETURN")})
  private void postLoadWorld(glo paramglo, fzo.a parama, CallbackInfo paramCallbackInfo) {
    BaritoneAPI.getProvider().getPrimaryBaritone().getGameEventHandler().onWorldEvent(new WorldEvent(paramglo, EventState.POST));
  }
  
  @Redirect(method = {"tick"}, at = @At(value = "FIELD", opcode = 180, target = "Lnet/minecraft/client/Minecraft;screen:Lnet/minecraft/client/gui/screens/Screen;"), slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/DebugScreenOverlay;showDebugScreen()Z"), to = @At(value = "CONSTANT", args = {"stringValue=Keybindings"})))
  private fzq passEvents(fqq paramfqq) {
    return (BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().isPathing() && this.t != null) ? null : paramfqq.z;
  }
}
