package baritone.command.defaults;

package .tmp;

import alr;
import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.helpers.TabCompleteHelper;
import bxe;
import bxn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import mh;

public final class FollowCommand extends Command {
  public FollowCommand(a parama) {
    super((IBaritone)parama, new String[] { "follow" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.requireMin(1);
    ArrayList<bxe> arrayList = new ArrayList();
    ArrayList<bxn> arrayList1 = new ArrayList();
    paramIArgConsumer.requireMin(2);
    FollowGroup followGroup = null;
    FollowList followList = (FollowList)paramIArgConsumer.getEnum(FollowList.class);
    while (paramIArgConsumer.hasAny()) {
      Object object;
      if (object = paramIArgConsumer.getDatatypeFor(followList.a) instanceof bxn) {
        arrayList1.add((bxn)object);
        continue;
      } 
      if (object != null)
        arrayList.add((bxe)object); 
    } 
    Objects.requireNonNull(arrayList);
    this.baritone.getFollowProcess().follow(paramIArgConsumer.hasExactlyOne() ? (followGroup = (FollowGroup)paramIArgConsumer.getEnum(FollowGroup.class)).a : (arrayList1.isEmpty() ? arrayList::contains : (parambxe -> paramList.stream().anyMatch(()))));
    if (followGroup != null) {
      logDirect(String.format("Following all %s", new Object[] { followGroup.name().toLowerCase(Locale.US) }));
      return;
    } 
    if (arrayList1.isEmpty()) {
      if (arrayList.isEmpty())
        throw new a(); 
      logDirect("Following these entities:");
      arrayList.stream().map(bxe::toString).forEach(this::logDirect);
      return;
    } 
    logDirect("Following these types of entities:");
    Objects.requireNonNull(mh.f);
    arrayList1.stream().map(mh.f::b).map(Objects::requireNonNull).map(alr::toString).forEach(this::logDirect);
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    IDatatypeFor iDatatypeFor;
    if (paramIArgConsumer.hasExactlyOne())
      return (new TabCompleteHelper()).append(FollowGroup.class).append(FollowList.class).filterPrefix(paramIArgConsumer.getString()).stream(); 
    try {
      iDatatypeFor = ((FollowList)paramIArgConsumer.getEnum(FollowList.class)).a;
    } catch (NullPointerException nullPointerException) {
      return Stream.empty();
    } 
    while (paramIArgConsumer.has(2)) {
      if (paramIArgConsumer.peekDatatypeOrNull(iDatatypeFor) == null)
        return Stream.empty(); 
      paramIArgConsumer.get();
    } 
    return paramIArgConsumer.tabCompleteDatatype((IDatatype)iDatatypeFor);
  }
  
  public final String getShortDesc() {
    return "Follow entity things";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The follow command tells Baritone to follow certain kinds of entities.", "", "Usage:", "> follow entities - Follows all entities.", "> follow entity <entity1> <entity2> <...> - Follow certain entities (for example 'skeleton', 'horse' etc.)", "> follow players - Follow players", "> follow player <username1> <username2> <...> - Follow certain players" });
  }
}
