package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.cache.IWaypoint;
import baritone.api.cache.IWorldData;
import baritone.api.cache.Waypoint;
import baritone.api.command.Command;
import baritone.api.command.IBaritoneChatControl;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForWaypoints;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeBlockPos;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.helpers.Paginator;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import iw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import o;
import xe;
import xg;
import xm;
import xu;

public final class bs extends Command {
  private Map<IWorldData, List<IWaypoint>> a = new HashMap<>();
  
  public bs(a parama) {
    super((IBaritone)parama, new String[] { "waypoints", "waypoint", "wp" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    BiFunction<Waypoint, a, xg> biFunction;
    a a;
    if ((a = (a)(paramIArgConsumer.hasAny() ? a.a(paramIArgConsumer.getString()) : a.a)) == null)
      throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), "an action"); 
    Function<IWaypoint, xg> function = paramIWaypoint -> (xg)paramBiFunction.apply(paramIWaypoint, (parama == a.a) ? a.d : parama);
    if (a == a.a) {
      IWaypoint.Tag tag;
      if ((tag = (IWaypoint.Tag)(paramIArgConsumer.hasAny() ? IWaypoint.Tag.getByName(paramIArgConsumer.peekString()) : null)) != null)
        paramIArgConsumer.get(); 
      IWaypoint[] arrayOfIWaypoint1;
      if ((arrayOfIWaypoint1 = (tag != null) ? ForWaypoints.getWaypointsByTag(this.baritone, tag) : ForWaypoints.getWaypoints(this.baritone)).length > 0) {
        paramIArgConsumer.requireMax(1);
        Paginator.paginate(paramIArgConsumer, (Object[])arrayOfIWaypoint1, () -> logDirect((paramTag != null) ? String.format("All waypoints by tag %s:", new Object[] { paramTag.name() }) : "All waypoints:"), function, String.format("%s%s %s%s", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, a.a[0], (tag != null) ? (" " + tag.getName()) : "" }));
        return;
      } 
      paramIArgConsumer.requireMax(0);
      throw new CommandInvalidStateException((tag != null) ? "No waypoints found by that tag" : "No waypoints found");
    } 
    if (a == a.c) {
      IWaypoint.Tag tag;
      if ((tag = (IWaypoint.Tag)(paramIArgConsumer.hasAny() ? IWaypoint.Tag.getByName(paramIArgConsumer.peekString()) : null)) == null) {
        tag = IWaypoint.Tag.USER;
      } else {
        paramIArgConsumer.get();
      } 
      String str = (paramIArgConsumer.hasExactlyOne() || paramIArgConsumer.hasExactly(4)) ? paramIArgConsumer.getString() : "";
      BetterBlockPos betterBlockPos = paramIArgConsumer.hasAny() ? (BetterBlockPos)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeBlockPos.INSTANCE, this.ctx.playerFeet()) : this.ctx.playerFeet();
      paramIArgConsumer.requireMax(0);
      Waypoint waypoint = new Waypoint(str, tag, betterBlockPos);
      ForWaypoints.waypoints(this.baritone).addWaypoint((IWaypoint)waypoint);
      xu xu;
      xg.b("Waypoint added: ").b((xu = xg.b("Waypoint added: ")).a().a(o.h));
      xu.b(biFunction.apply(waypoint, a.d));
      logDirect(new xg[] { (xg)xu });
      return;
    } 
    if (a == a.b) {
      paramIArgConsumer.requireMax(1);
      String str;
      IWaypoint.Tag tag;
      if ((tag = IWaypoint.Tag.getByName(str = paramIArgConsumer.getString())) == null)
        throw new CommandInvalidStateException("Invalid tag, \"" + str + "\""); 
      IWaypoint[] arrayOfIWaypoint1;
      IWaypoint[] arrayOfIWaypoint2;
      int i = (arrayOfIWaypoint2 = arrayOfIWaypoint1 = ForWaypoints.getWaypointsByTag(this.baritone, tag)).length;
      for (byte b = 0; b < i; b++) {
        IWaypoint iWaypoint1 = arrayOfIWaypoint2[b];
        ForWaypoints.waypoints(this.baritone).removeWaypoint(iWaypoint1);
      } 
      ((List)this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), paramIWorldData -> new ArrayList())).addAll(Arrays.asList(arrayOfIWaypoint1));
      xu xu;
      xg.b(String.format("Cleared %d waypoints, click to restore them", new Object[] { Integer.valueOf(arrayOfIWaypoint1.length) })).b((xu = xg.b(String.format("Cleared %d waypoints, click to restore them", new Object[] { Integer.valueOf(arrayOfIWaypoint1.length) }))).a().a((xe)new xe.f(String.format("%s%s restore @ %s", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, Stream.<IWaypoint>of(arrayOfIWaypoint1).map(paramIWaypoint -> Long.toString(paramIWaypoint.getCreationTimestamp())).collect(Collectors.joining(" ")) }))));
      logDirect(new xg[] { (xg)xu });
      return;
    } 
    if (a == a.f) {
      ArrayList<IWaypoint> arrayList = new ArrayList();
      List<? extends IWaypoint> list = this.a.getOrDefault(this.baritone.getWorldProvider().getCurrentWorld(), Collections.emptyList());
      if (paramIArgConsumer.peekString().equals("@")) {
        paramIArgConsumer.get();
        while (paramIArgConsumer.hasAny()) {
          long l = ((Long)paramIArgConsumer.getAs(Long.class)).longValue();
          Iterator<IWaypoint> iterator = list.iterator();
          while (iterator.hasNext()) {
            IWaypoint iWaypoint1;
            if ((iWaypoint1 = iterator.next()).getCreationTimestamp() == l)
              arrayList.add(iWaypoint1); 
          } 
        } 
      } else {
        paramIArgConsumer.requireExactly(1);
        int i;
        int j = Math.min(i = list.size(), ((Integer)paramIArgConsumer.getAs(Integer.class)).intValue());
        arrayList = new ArrayList<>(list.subList(i - j, i));
      } 
      Objects.requireNonNull(ForWaypoints.waypoints(this.baritone));
      arrayList.forEach(ForWaypoints.waypoints(this.baritone)::addWaypoint);
      Objects.requireNonNull(arrayList);
      list.removeIf(arrayList::contains);
      logDirect(String.format("Restored %d waypoints", new Object[] { Integer.valueOf(arrayList.size()) }));
      return;
    } 
    IWaypoint[] arrayOfIWaypoint = (IWaypoint[])paramIArgConsumer.getDatatypeFor((IDatatypeFor)ForWaypoints.INSTANCE);
    IWaypoint iWaypoint = null;
    if (paramIArgConsumer.hasAny() && paramIArgConsumer.peekString().equals("@")) {
      paramIArgConsumer.requireExactly(2);
      paramIArgConsumer.get();
      long l = ((Long)paramIArgConsumer.getAs(Long.class)).longValue();
      IWaypoint[] arrayOfIWaypoint1;
      int i = (arrayOfIWaypoint1 = arrayOfIWaypoint).length;
      for (byte b = 0; b < i; b++) {
        IWaypoint iWaypoint1;
        if ((iWaypoint1 = arrayOfIWaypoint1[b]).getCreationTimestamp() == l) {
          iWaypoint = iWaypoint1;
          break;
        } 
      } 
      if (iWaypoint == null)
        throw new CommandInvalidStateException("Timestamp was specified but no waypoint was found"); 
    } else {
      switch (arrayOfIWaypoint.length) {
        case 0:
          throw new CommandInvalidStateException("No waypoints found");
        case 1:
          iWaypoint = arrayOfIWaypoint[0];
          break;
      } 
    } 
    if (iWaypoint == null) {
      paramIArgConsumer.requireMax(1);
      Paginator.paginate(paramIArgConsumer, (Object[])arrayOfIWaypoint, () -> logDirect("Multiple waypoints were found:"), function, String.format("%s%s %s %s", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, a.a[0], paramIArgConsumer.consumedString() }));
      return;
    } 
    if (a == a.d) {
      logDirect(new xg[] { function.apply(iWaypoint) });
      logDirect(String.format("Position: %s", new Object[] { iWaypoint.getLocation() }));
      xu xu2;
      xg.b("Click to delete this waypoint").b((xu2 = xg.b("Click to delete this waypoint")).a().a((xe)new xe.f(String.format("%s%s delete %s @ %d", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, iWaypoint.getTag().getName(), Long.valueOf(iWaypoint.getCreationTimestamp()) }))));
      xu xu3;
      xg.b("Click to set goal to this waypoint").b((xu3 = xg.b("Click to set goal to this waypoint")).a().a((xe)new xe.f(String.format("%s%s goal %s @ %d", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, iWaypoint.getTag().getName(), Long.valueOf(iWaypoint.getCreationTimestamp()) }))));
      xu xu4;
      xg.b("Click to show a command to recreate this waypoint").b((xu4 = xg.b("Click to show a command to recreate this waypoint")).a().a((xe)new xe.g(String.format("%s%s save %s %s %s %s %s", new Object[] { (a.a()).prefix.value, paramString, iWaypoint.getTag().getName(), iWaypoint.getName(), Integer.valueOf((iWaypoint.getLocation()).x), Integer.valueOf((iWaypoint.getLocation()).y), Integer.valueOf((iWaypoint.getLocation()).z) }))));
      xu xu1;
      xg.b("Click to return to the waypoints list").b((xu1 = xg.b("Click to return to the waypoints list")).a().a((xe)new xe.f(String.format("%s%s list", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString }))));
      logDirect(new xg[] { (xg)xu2 });
      logDirect(new xg[] { (xg)xu3 });
      logDirect(new xg[] { (xg)xu4 });
      logDirect(new xg[] { (xg)xu1 });
      return;
    } 
    if (a == a.e) {
      ForWaypoints.waypoints(this.baritone).removeWaypoint(iWaypoint);
      ((List<IWaypoint>)this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), paramIWorldData -> new ArrayList())).add(iWaypoint);
      xu xu;
      xg.b("That waypoint has successfully been deleted, click to restore it").b((xu = xg.b("That waypoint has successfully been deleted, click to restore it")).a().a((xe)new xe.f(String.format("%s%s restore @ %s", new Object[] { IBaritoneChatControl.FORCE_COMMAND_PREFIX, paramString, Long.valueOf(iWaypoint.getCreationTimestamp()) }))));
      logDirect(new xg[] { (xg)xu });
      return;
    } 
    if (a == a.g) {
      GoalBlock goalBlock = new GoalBlock((iw)iWaypoint.getLocation());
      this.baritone.getCustomGoalProcess().setGoal((Goal)goalBlock);
      logDirect(String.format("Goal: %s", new Object[] { goalBlock }));
      return;
    } 
    if (a == a.h) {
      GoalBlock goalBlock = new GoalBlock((iw)iWaypoint.getLocation());
      this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)goalBlock);
      logDirect(String.format("Going to: %s", new Object[] { goalBlock }));
    } 
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    if (paramIArgConsumer.hasAny()) {
      if (paramIArgConsumer.hasExactlyOne())
        return (new TabCompleteHelper()).append(a.a()).sortAlphabetically().filterPrefix(paramIArgConsumer.getString()).stream(); 
      a a = a.a(paramIArgConsumer.getString());
      if (paramIArgConsumer.hasExactlyOne())
        return (a == a.a || a == a.c || a == a.b) ? (new TabCompleteHelper()).append(IWaypoint.Tag.getAllNames()).sortAlphabetically().filterPrefix(paramIArgConsumer.getString()).stream() : ((a == a.f) ? Stream.empty() : paramIArgConsumer.tabCompleteDatatype((IDatatype)ForWaypoints.INSTANCE)); 
      if (paramIArgConsumer.has(3) && a == a.c) {
        paramIArgConsumer.get();
        paramIArgConsumer.get();
        return paramIArgConsumer.tabCompleteDatatype((IDatatype)RelativeBlockPos.INSTANCE);
      } 
    } 
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Manage waypoints";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { 
          "The waypoint command allows you to manage Baritone's waypoints.", "", "Waypoints can be used to mark positions for later. Waypoints are each given a tag and an optional name.", "", "Note that the info, delete, and goal commands let you specify a waypoint by tag. If there is more than one waypoint with a certain tag, then they will let you select which waypoint you mean.", "", "Missing arguments for the save command use the USER tag, creating an unnamed waypoint and your current position as defaults.", "", "Usage:", "> wp [l/list] - List all waypoints.", 
          "> wp <l/list> <tag> - List all waypoints by tag.", "> wp <s/save> - Save an unnamed USER waypoint at your current position", "> wp <s/save> [tag] [name] [pos] - Save a waypoint with the specified tag, name and position.", "> wp <i/info/show> <tag/name> - Show info on a waypoint by tag or name.", "> wp <d/delete> <tag/name> - Delete a waypoint by tag or name.", "> wp <restore> <n> - Restore the last n deleted waypoints.", "> wp <c/clear> <tag> - Delete all waypoints with the specified tag.", "> wp <g/goal> <tag/name> - Set a goal to a waypoint by tag or name.", "> wp <goto> <tag/name> - Set a goal to a waypoint by tag or name and start pathing." });
  }
}
