package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.Settings;
import baritone.api.command.Command;
import baritone.api.command.IBaritoneChatControl;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.RelativeFile;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.helpers.Paginator;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.utils.SettingsUtil;
import fqq;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import o;
import xe;
import xg;
import xm;
import xu;

public final class bm extends Command {
  public bm(a parama) {
    super((IBaritone)parama, new String[] { "set", "setting", "settings" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    paramString = paramIArgConsumer.hasAny() ? paramIArgConsumer.getString().toLowerCase(Locale.US) : "list";
    if (Arrays.<String>asList(new String[] { "s", "save" }).contains(paramString)) {
      SettingsUtil.save(a.a());
      logDirect("Settings saved");
      return;
    } 
    if (Arrays.<String>asList(new String[] { "load", "ld" }).contains(paramString)) {
      String str1 = "settings.txt";
      if (paramIArgConsumer.hasAny())
        str1 = paramIArgConsumer.getString(); 
      SettingsUtil.modifiedSettings(a.a()).forEach(Settings.Setting::reset);
      SettingsUtil.readAndApply(a.a(), str1);
      logDirect("Settings reloaded from " + str1);
      return;
    } 
    boolean bool1 = Arrays.<String>asList(new String[] { "m", "mod", "modified" }).contains(paramString);
    boolean bool2 = Arrays.<String>asList(new String[] { "all", "l", "list" }).contains(paramString);
    if ((bool1 || bool2)) {
      String str1 = (paramIArgConsumer.hasAny() && paramIArgConsumer.peekAsOrNull(Integer.class) == null) ? paramIArgConsumer.getString() : "";
      paramIArgConsumer.requireMax(1);
      List list = (List)(bool1 ? SettingsUtil.modifiedSettings(a.a()) : (a.a()).allSettings).stream().filter(paramSetting -> !paramSetting.isJavaOnly()).filter(paramSetting -> paramSetting.getName().toLowerCase(Locale.US).contains(paramString.toLowerCase(Locale.US))).sorted((paramSetting1, paramSetting2) -> String.CASE_INSENSITIVE_ORDER.compare(paramSetting1.getName(), paramSetting2.getName())).collect(Collectors.toList());
      Paginator.paginate(paramIArgConsumer, new Paginator(list), () -> {
            (new Object[2])[0] = paramBoolean ? "modified " : "";
            logDirect(String.format("All %ssettings:", new Object[] { !paramString.isEmpty() ? paramString : (paramBoolean ? "modified " : "") }));
          }paramSetting -> {
            xu xu2;
            xg.b(String.format(" (%s)", new Object[] { SettingsUtil.settingTypeToString(paramSetting) })).b((xu2 = xg.b(String.format(" (%s)", new Object[] { SettingsUtil.settingTypeToString(paramSetting) }))).a().a(o.i));
            xu xu3;
            xg.b("").b((xu3 = xg.b("")).a().a(o.h));
            xu3.f(paramSetting.getName());
            xu3.f(String.format("\nType: %s", new Object[] { SettingsUtil.settingTypeToString(paramSetting) }));
            xu3.f(String.format("\n\nValue:\n%s", new Object[] { SettingsUtil.settingValueToString(paramSetting) }));
            xu3.f(String.format("\n\nDefault Value:\n%s", new Object[] { SettingsUtil.settingDefaultToString(paramSetting) }));
            String str = (String)(a.a()).prefix.value + (String)(a.a()).prefix.value;
            xu xu1;
            xg.b(paramSetting.getName()).b((xu1 = xg.b(paramSetting.getName())).a().a(o.h));
            xu1.b((xg)xu2);
            xu1.b(xu1.a().a((xm)new xm.e((xg)xu3)).a((xe)new xe.g(str)));
            return (xg)xu1;
          }IBaritoneChatControl.FORCE_COMMAND_PREFIX + "set " + IBaritoneChatControl.FORCE_COMMAND_PREFIX + " " + paramString);
      return;
    } 
    paramIArgConsumer.requireMax(1);
    bool2 = paramString.equalsIgnoreCase("reset");
    boolean bool3 = paramString.equalsIgnoreCase("toggle");
    bool1 = (bool2 || bool3);
    if (bool2)
      if (!paramIArgConsumer.hasAny()) {
        logDirect("Please specify 'all' as an argument to reset to confirm you'd really like to do this");
        logDirect("ALL settings will be reset. Use the 'set modified' or 'modified' commands to see what will be reset.");
        logDirect("Specify a setting name instead of 'all' to only reset one setting");
      } else if (paramIArgConsumer.peekString().equalsIgnoreCase("all")) {
        SettingsUtil.modifiedSettings(a.a()).forEach(Settings.Setting::reset);
        logDirect("All settings have been reset to their default values");
        SettingsUtil.save(a.a());
        return;
      }  
    if (bool3)
      paramIArgConsumer.requireMin(1); 
    String str = bool1 ? paramIArgConsumer.getString() : paramString;
    Settings.Setting setting;
    if ((setting = (a.a()).allSettings.stream().filter(paramSetting -> paramSetting.getName().equalsIgnoreCase(paramString)).findFirst().orElse(null)) == null)
      throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), "a valid setting"); 
    if (setting.isJavaOnly())
      throw new CommandInvalidStateException(String.format("Setting %s can only be used via the api.", new Object[] { setting.getName() })); 
    if (!bool1 && !paramIArgConsumer.hasAny()) {
      logDirect(String.format("Value of setting %s:", new Object[] { setting.getName() }));
      logDirect(SettingsUtil.settingValueToString(setting));
    } else {
      String str1 = SettingsUtil.settingValueToString(setting);
      if (bool2) {
        setting.reset();
      } else if (bool3) {
        if (setting.getValueClass() != Boolean.class)
          throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), "a toggleable setting", "some other setting"); 
        setting.value = Boolean.valueOf(((Boolean)setting.value).booleanValue() ^ true);
        logDirect(String.format("Toggled setting %s to %s", new Object[] { setting.getName(), Boolean.toString(((Boolean)setting.value).booleanValue()) }));
      } else {
        String str2 = paramIArgConsumer.getString();
        try {
          SettingsUtil.parseAndApply(a.a(), paramString, str2);
        } catch (Throwable throwable) {
          (paramString = null).printStackTrace();
          throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), "a valid value", paramString);
        } 
      } 
      if (!bool3)
        logDirect(String.format("Successfully %s %s to %s", new Object[] { bool2 ? "reset" : "set", setting.getName(), SettingsUtil.settingValueToString(setting) })); 
      xu xu;
      xg.b(String.format("Old value: %s", new Object[] { str1 })).b((xu = xg.b(String.format("Old value: %s", new Object[] { str1 }))).a().a(o.h).a((xm)new xm.e((xg)xg.b("Click to set the setting back to this value"))).a((xe)new xe.f(IBaritoneChatControl.FORCE_COMMAND_PREFIX + IBaritoneChatControl.FORCE_COMMAND_PREFIX)));
      logDirect(new xg[] { (xg)xu });
      if ((setting.getName().equals("chatControl") && !((Boolean)setting.value).booleanValue() && !((Boolean)(a.a()).chatControlAnyway.value).booleanValue()) || (setting.getName().equals("chatControlAnyway") && !((Boolean)setting.value).booleanValue() && !((Boolean)(a.a()).chatControl.value).booleanValue())) {
        logDirect("Warning: Chat commands will no longer work. If you want to revert this change, use prefix control (if enabled) or click the old value listed above.", o.m);
      } else if (setting.getName().equals("prefixControl") && !((Boolean)setting.value).booleanValue()) {
        logDirect("Warning: Prefixed commands will no longer work. If you want to revert this change, use chat control (if enabled) or click the old value listed above.", o.m);
      } 
    } 
    SettingsUtil.save(a.a());
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    if (paramIArgConsumer.hasAny()) {
      Settings.Setting setting;
      paramString = paramIArgConsumer.getString();
      if (paramIArgConsumer.hasExactlyOne() && !Arrays.<String>asList(new String[] { "s", "save" }).contains(paramIArgConsumer.peekString().toLowerCase(Locale.US))) {
        if (paramString.equalsIgnoreCase("reset"))
          return (new TabCompleteHelper()).addModifiedSettings().prepend(new String[] { "all" }).filterPrefix(paramIArgConsumer.getString()).stream(); 
        if (paramString.equalsIgnoreCase("toggle"))
          return (new TabCompleteHelper()).addToggleableSettings().filterPrefix(paramIArgConsumer.getString()).stream(); 
        if (Arrays.<String>asList(new String[] { "ld", "load" }).contains(paramString.toLowerCase(Locale.US)))
          return RelativeFile.tabComplete(paramIArgConsumer, (fqq.Q()).q.toPath().resolve("baritone").toFile()); 
        if ((setting = (Settings.Setting)(a.a()).byLowerName.get(paramString.toLowerCase(Locale.US))) != null) {
          if (setting.getType() == Boolean.class) {
            TabCompleteHelper tabCompleteHelper = new TabCompleteHelper();
            if (((Boolean)setting.value).booleanValue()) {
              tabCompleteHelper.append(new String[] { "true", "false" });
            } else {
              tabCompleteHelper.append(new String[] { "false", "true" });
            } 
            return tabCompleteHelper.filterPrefix(paramIArgConsumer.getString()).stream();
          } 
          return Stream.of(SettingsUtil.settingValueToString(setting));
        } 
      } else if (!paramIArgConsumer.hasAny()) {
        return (new TabCompleteHelper()).addSettings().sortAlphabetically().prepend(new String[] { "list", "modified", "reset", "toggle", "save", "load" }).filterPrefix((String)setting).stream();
      } 
    } 
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "View or change settings";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { 
          "Using the set command, you can manage all of Baritone's settings. Almost every aspect is controlled by these settings - go wild!", "", "Usage:", "> set - Same as `set list`", "> set list [page] - View all settings", "> set modified [page] - View modified settings", "> set <setting> - View the current value of a setting", "> set <setting> <value> - Set the value of a setting", "> set reset all - Reset ALL SETTINGS to their defaults", "> set reset <setting> - Reset a setting to its default", 
          "> set toggle <setting> - Toggle a boolean setting", "> set save - Save all settings (this is automatic tho)", "> set load - Load settings from settings.txt", "> set load [filename] - Load settings from another file in your minecraft/baritone" });
  }
}
