package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.pathing.calc.IPathingControlManager;
import baritone.api.process.IBaritoneProcess;
import baritone.api.process.PathingCommand;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class bf extends Command {
  public bf(a parama) {
    super((IBaritone)parama, new String[] { "proc" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.requireMax(0);
    IPathingControlManager iPathingControlManager;
    IBaritoneProcess iBaritoneProcess;
    if ((iBaritoneProcess = (iPathingControlManager = this.baritone.getPathingControlManager()).mostRecentInControl().orElse(null)) == null)
      throw new CommandInvalidStateException("No process in control"); 
    logDirect(String.format("Class: %s\nPriority: %f\nTemporary: %b\nDisplay name: %s\nLast command: %s", new Object[] { iBaritoneProcess.getClass().getTypeName(), Double.valueOf(iBaritoneProcess.priority()), Boolean.valueOf(iBaritoneProcess.isTemporary()), iBaritoneProcess.displayName(), iPathingControlManager.mostRecentCommand().map(PathingCommand::toString).orElse("None") }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "View process state information";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The proc command provides miscellaneous information about the process currently controlling Baritone.", "", "You are not expected to understand this if you aren't familiar with how Baritone works.", "", "Usage:", "> proc - View process information, if present" });
  }
}
