package baritone;

package .tmp;

import baritone.a;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForBlockOptionalMeta;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.utils.BlockOptionalMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class bc extends Command {
  public bc(a parama) {
    super((IBaritone)parama, new String[] { "mine" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    int i = ((Integer)paramIArgConsumer.getAsOrDefault(Integer.class, Integer.valueOf(0))).intValue();
    paramIArgConsumer.requireMin(1);
    ArrayList<BlockOptionalMeta> arrayList = new ArrayList();
    while (paramIArgConsumer.hasAny())
      arrayList.add((BlockOptionalMeta)paramIArgConsumer.getDatatypeFor((IDatatypeFor)ForBlockOptionalMeta.INSTANCE)); 
    BaritoneAPI.getProvider().getWorldScanner().repack(this.ctx);
    logDirect(String.format("Mining %s", new Object[] { arrayList.toString() }));
    this.baritone.getMineProcess().mine(i, arrayList.<BlockOptionalMeta>toArray(new BlockOptionalMeta[0]));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.getAsOrDefault(Integer.class, Integer.valueOf(0));
    while (paramIArgConsumer.has(2))
      paramIArgConsumer.getDatatypeFor((IDatatypeFor)ForBlockOptionalMeta.INSTANCE); 
    return paramIArgConsumer.tabCompleteDatatype((IDatatype)ForBlockOptionalMeta.INSTANCE);
  }
  
  public final String getShortDesc() {
    return "Mine some blocks";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The mine command allows you to tell Baritone to search for and mine individual blocks.", "", "The specified blocks can be ores, or any other block.", "", "Also see the legitMine settings (see #set l legitMine).", "", "Usage:", "> mine diamond_ore - Mines all diamonds it can find." });
  }
}
