package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalInverted;
import baritone.api.process.ICustomGoalProcess;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ba extends Command {
  public ba(a parama) {
    super((IBaritone)parama, new String[] { "invert" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    GoalInverted goalInverted;
    paramIArgConsumer.requireMax(0);
    ICustomGoalProcess iCustomGoalProcess;
    Goal goal;
    if ((goal = (iCustomGoalProcess = this.baritone.getCustomGoalProcess()).getGoal()) == null)
      throw new CommandInvalidStateException("No goal"); 
    if (goal instanceof GoalInverted) {
      goal = ((GoalInverted)goal).origin;
    } else {
      goalInverted = new GoalInverted(goal);
    } 
    iCustomGoalProcess.setGoalAndPath((Goal)goalInverted);
    logDirect(String.format("Goal: %s", new Object[] { goalInverted.toString() }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Run away from the current goal";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The invert command tells Baritone to head away from the current goal rather than towards it.", "", "Usage:", "> invert - Invert the current goal." });
  }
}
