package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForBlockOptionalMeta;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeCoordinate;
import baritone.api.command.datatypes.RelativeGoal;
import baritone.api.pathing.goals.Goal;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.BlockOptionalMeta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ay extends Command {
  protected ay(a parama) {
    super((IBaritone)parama, new String[] { "goto" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    if (paramIArgConsumer.peekDatatypeOrNull((IDatatypePost)RelativeCoordinate.INSTANCE) != null) {
      paramIArgConsumer.requireMax(3);
      BetterBlockPos betterBlockPos = this.ctx.playerFeet();
      Goal goal = (Goal)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeGoal.INSTANCE, betterBlockPos);
      logDirect(String.format("Going to: %s", new Object[] { goal.toString() }));
      this.baritone.getCustomGoalProcess().setGoalAndPath(goal);
      return;
    } 
    paramIArgConsumer.requireMax(1);
    BlockOptionalMeta blockOptionalMeta = (BlockOptionalMeta)paramIArgConsumer.getDatatypeFor((IDatatypeFor)ForBlockOptionalMeta.INSTANCE);
    this.baritone.getGetToBlockProcess().getToBlock(blockOptionalMeta);
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.requireMax(1);
    return paramIArgConsumer.tabCompleteDatatype((IDatatype)ForBlockOptionalMeta.INSTANCE);
  }
  
  public final String getShortDesc() {
    return "Go to a coordinate or block";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The goto command tells Baritone to head towards a given goal or block.", "", "Wherever a coordinate is expected, you can use ~ just like in regular Minecraft commands. Or, you can just use regular numbers.", "", "Usage:", "> goto <block> - Go to a block, wherever it is in the world", "> goto <y> - Go to a Y level", "> goto <x> <z> - Go to an X,Z position", "> goto <x> <y> <z> - Go to an X,Y,Z position" });
  }
}
