package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeCoordinate;
import baritone.api.command.datatypes.RelativeGoal;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.pathing.goals.Goal;
import baritone.api.process.ICustomGoalProcess;
import baritone.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ax extends Command {
  public ax(a parama) {
    super((IBaritone)parama, new String[] { "goal" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    ICustomGoalProcess iCustomGoalProcess = this.baritone.getCustomGoalProcess();
    if (paramIArgConsumer.hasAny() && Arrays.<String>asList(new String[] { "reset", "clear", "none" }).contains(paramIArgConsumer.peekString())) {
      paramIArgConsumer.requireMax(1);
      if (iCustomGoalProcess.getGoal() != null) {
        iCustomGoalProcess.setGoal(null);
        logDirect("Cleared goal");
        return;
      } 
      logDirect("There was no goal to clear");
      return;
    } 
    paramIArgConsumer.requireMax(3);
    BetterBlockPos betterBlockPos = this.ctx.playerFeet();
    Goal goal = (Goal)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeGoal.INSTANCE, betterBlockPos);
    iCustomGoalProcess.setGoal(goal);
    logDirect(String.format("Goal: %s", new Object[] { goal.toString() }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    TabCompleteHelper tabCompleteHelper = new TabCompleteHelper();
    if (paramIArgConsumer.hasExactlyOne()) {
      tabCompleteHelper.append(new String[] { "reset", "clear", "none", "~" });
    } else if (paramIArgConsumer.hasAtMost(3)) {
      while (paramIArgConsumer.has(2) && paramIArgConsumer.peekDatatypeOrNull((IDatatypePost)RelativeCoordinate.INSTANCE) != null) {
        paramIArgConsumer.get();
        if (!paramIArgConsumer.has(2))
          tabCompleteHelper.append(new String[] { "~" }); 
      } 
    } 
    return tabCompleteHelper.filterPrefix(paramIArgConsumer.getString()).stream();
  }
  
  public final String getShortDesc() {
    return "Set or clear the goal";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "The goal command allows you to set or clear Baritone's goal.", "", "Wherever a coordinate is expected, you can use ~ just like in regular Minecraft commands. Or, you can just use regular numbers.", "", "Usage:", "> goal - Set the goal to your current position", "> goal <reset/clear/none> - Erase the goal", "> goal <y> - Set the goal to a Y level", "> goal <x> <z> - Set the goal to an X,Z position", "> goal <x> <y> <z> - Set the goal to an X,Y,Z position" });
  }
}
