package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeFile;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class as extends Command {
  public as(a parama) {
    super((IBaritone)parama, new String[] { "explorefilter" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.requireMax(2);
    File file = (File)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeFile.INSTANCE, (this.ctx.minecraft()).q.getAbsoluteFile().getParentFile());
    boolean bool = false;
    if (paramIArgConsumer.hasAny())
      if (paramIArgConsumer.getString().equalsIgnoreCase("invert")) {
        bool = true;
      } else {
        throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), "either \"invert\" or nothing");
      }  
    try {
      this.baritone.getExploreProcess().applyJsonFilter(file.toPath().toAbsolutePath(), bool);
    } catch (NoSuchFileException noSuchFileException) {
      throw new CommandInvalidStateException("File not found");
    } catch (JsonSyntaxException jsonSyntaxException) {
      throw new CommandInvalidStateException("Invalid JSON syntax");
    } catch (Exception exception) {
      throw new IllegalStateException(exception);
    } 
    logDirect(String.format("Explore filter applied. Inverted: %s", new Object[] { Boolean.toString(bool) }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    return paramIArgConsumer.hasExactlyOne() ? RelativeFile.tabComplete(paramIArgConsumer, RelativeFile.gameDir(this.ctx.minecraft())) : Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Explore chunks from a json";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "Apply an explore filter before using explore, which tells the explore process which chunks have been explored/not explored.", "", "The JSON file will follow this format: [{\"x\":0,\"z\":0},...]", "", "If 'invert' is specified, the chunks listed will be considered NOT explored, rather than explored.", "", "Usage:", "> explorefilter <path> [invert] - Load the JSON file referenced by the specified path. If invert is specified, it must be the literal word 'invert'." });
  }
}
