package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeGoalXZ;
import baritone.api.pathing.goals.GoalXZ;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ar extends Command {
  public ar(a parama) {
    super((IBaritone)parama, new String[] { "explore" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    if (paramIArgConsumer.hasAny()) {
      paramIArgConsumer.requireExactly(2);
    } else {
      paramIArgConsumer.requireMax(0);
    } 
    GoalXZ goalXZ = paramIArgConsumer.hasAny() ? (GoalXZ)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeGoalXZ.INSTANCE, this.ctx.playerFeet()) : new GoalXZ(this.ctx.playerFeet());
    this.baritone.getExploreProcess().explore(goalXZ.getX(), goalXZ.getZ());
    logDirect(String.format("Exploring from %s", new Object[] { goalXZ.toString() }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    return paramIArgConsumer.hasAtMost(2) ? paramIArgConsumer.tabCompleteDatatype((IDatatype)RelativeGoalXZ.INSTANCE) : Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Explore things";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "Tell Baritone to explore randomly. If you used explorefilter before this, it will be applied.", "", "Usage:", "> explore - Explore from your current position.", "> explore <x> <z> - Explore from the specified X and Z position." });
  }
}
