package baritone.api.utils;

package .tmp;

import baritone.api.BaritoneAPI;
import baritone.api.Settings;
import baritone.api.utils.Helper;
import fqq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SettingsUtil {
  public static final String SETTINGS_DEFAULT_NAME = "settings.txt";
  
  private static final Pattern SETTING_PATTERN = Pattern.compile("^(?<setting>[^ ]+) +(?<value>.+)");
  
  private static boolean isComment(String paramString) {
    return (paramString.startsWith("#") || paramString.startsWith("//"));
  }
  
  private static void forEachLine(Path paramPath, Consumer<String> paramConsumer) {
    BufferedReader bufferedReader = Files.newBufferedReader(paramPath);
    try {
      String str;
      while ((str = bufferedReader.readLine()) != null) {
        if (!str.isEmpty() && !isComment(str))
          paramConsumer.accept(str); 
      } 
      if (bufferedReader != null) {
        bufferedReader.close();
        return;
      } 
    } catch (Throwable throwable) {
      if (bufferedReader != null)
        try {
          bufferedReader.close();
        } catch (Throwable throwable1) {
          throwable.addSuppressed(throwable1);
        }  
      throw throwable;
    } 
  }
  
  public static void readAndApply(Settings paramSettings, String paramString) {
    try {
      forEachLine(settingsByName(paramString), paramString -> {
            Matcher matcher;
            if (!(matcher = SETTING_PATTERN.matcher(paramString)).matches()) {
              Helper.HELPER.logDirect("Invalid syntax in setting file: " + paramString);
              return;
            } 
            String str2 = matcher.group("setting").toLowerCase();
            String str1 = matcher.group("value");
            if ("allowjumpat256".equals(str2))
              str2 = "allowjumpatbuildlimit"; 
            try {
              parseAndApply(paramSettings, str2, str1);
              return;
            } catch (Exception exception) {
              Helper.HELPER.logDirect("Unable to parse line " + paramString);
              exception.printStackTrace();
              return;
            } 
          });
      return;
    } catch (NoSuchFileException noSuchFileException) {
      Helper.HELPER.logDirect("Baritone settings file not found, resetting.");
      return;
    } catch (Exception exception) {
      Helper.HELPER.logDirect("Exception while reading Baritone settings, some settings may be reset to default values!");
      exception.printStackTrace();
      return;
    } 
  }
  
  public static synchronized void save(Settings paramSettings) {
    try {
      BufferedWriter bufferedWriter = Files.newBufferedWriter(settingsByName("settings.txt"), new java.nio.file.OpenOption[0]);
      try {
        for (Settings.Setting setting : modifiedSettings(paramSettings))
          bufferedWriter.write(settingToString(setting) + "\n"); 
        if (bufferedWriter != null) {
          bufferedWriter.close();
          return;
        } 
      } catch (Throwable throwable) {
        if (bufferedWriter != null)
          try {
            bufferedWriter.close();
          } catch (Throwable throwable1) {
            throwable.addSuppressed(throwable1);
          }  
        throw throwable;
      } 
      return;
    } catch (Exception exception) {
      Helper.HELPER.logDirect("Exception thrown while saving Baritone settings!");
      exception.printStackTrace();
      return;
    } 
  }
  
  private static Path settingsByName(String paramString) {
    return (fqq.Q()).q.toPath().resolve("baritone").resolve(paramString);
  }
  
  public static List<Settings.Setting> modifiedSettings(Settings paramSettings) {
    ArrayList<Settings.Setting> arrayList = new ArrayList();
    Iterator<Settings.Setting> iterator = paramSettings.allSettings.iterator();
    while (iterator.hasNext()) {
      Settings.Setting setting;
      if ((setting = iterator.next()).value == null) {
        System.out.println("NULL SETTING?" + setting.getName());
        continue;
      } 
      if (!setting.isJavaOnly() && setting.value != setting.defaultValue)
        arrayList.add(setting); 
    } 
    return arrayList;
  }
  
  public static String settingTypeToString(Settings.Setting paramSetting) {
    return paramSetting.getType().getTypeName().replaceAll("(?:\\w+\\.)+(\\w+)", "$1");
  }
  
  public static <T> String settingValueToString(Settings.Setting<T> paramSetting, T paramT) {
    Parser parser;
    if ((parser = Parser.getParser(paramSetting.getType())) == null)
      throw new IllegalStateException("Missing " + String.valueOf(paramSetting.getValueClass()) + " " + paramSetting.getName()); 
    return parser.toString(paramSetting.getType(), paramT);
  }
  
  public static String settingValueToString(Settings.Setting paramSetting) {
    return settingValueToString(paramSetting, paramSetting.value);
  }
  
  public static String settingDefaultToString(Settings.Setting paramSetting) {
    return settingValueToString(paramSetting, paramSetting.defaultValue);
  }
  
  public static String maybeCensor(int paramInt) {
    return ((Boolean)(BaritoneAPI.getSettings()).censorCoordinates.value).booleanValue() ? "<censored>" : Integer.toString(paramInt);
  }
  
  public static String settingToString(Settings.Setting paramSetting) {
    return paramSetting.isJavaOnly() ? paramSetting.getName() : (paramSetting.getName() + " " + paramSetting.getName());
  }
  
  @Deprecated
  public static boolean javaOnlySetting(Settings.Setting paramSetting) {
    return paramSetting.isJavaOnly();
  }
  
  public static void parseAndApply(Settings paramSettings, String paramString1, String paramString2) {
    Settings.Setting setting;
    if ((setting = (Settings.Setting)paramSettings.byLowerName.get(paramString1)) == null)
      throw new IllegalStateException("No setting by that name"); 
    Class clazz = setting.getValueClass();
    Parser parser;
    Object object = (parser = Parser.getParser(setting.getType())).parse(setting.getType(), paramString2);
    if (!clazz.isInstance(object))
      throw new IllegalStateException(String.valueOf(parser) + " parser returned incorrect type, expected " + String.valueOf(parser) + " got " + String.valueOf(clazz) + " which is " + String.valueOf(object)); 
    setting.value = object;
  }
}
