package baritone.api.utils;

package .tmp;

import alr;
import baritone.api.utils.BlockUtils;
import baritone.api.utils.SettingsUtil;
import dag;
import dno;
import dsr;
import dui;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import jg;
import kb;
import mh;

enum Parser implements SettingsUtil.ISettingParser {
  DOUBLE((Class)Double.class, Double::parseDouble),
  BOOLEAN((Class)Boolean.class, Boolean::parseBoolean),
  INTEGER((Class)Integer.class, Integer::parseInt),
  FLOAT((Class)Float.class, Float::parseFloat),
  LONG((Class)Long.class, Long::parseLong),
  STRING((Class)String.class, String::new),
  MIRROR((Class)dsr.class, dsr::valueOf, Enum::name),
  ROTATION((Class)dui.class, dui::valueOf, Enum::name),
  COLOR((Class)dui.class, dui::valueOf, Enum::name),
  VEC3I((Class)dui.class, dui::valueOf, Enum::name),
  BLOCK((Class)dui.class, dui::valueOf, Enum::name),
  ITEM((Class)dui.class, dui::valueOf, Enum::name),
  LIST,
  MAPPING;
  
  private final Class<?> cla$$ = null;
  
  private final Function<String, Object> parser;
  
  private final Function<Object, String> toString;
  
  Parser() {
    this.parser = null;
    this.toString = null;
  }
  
  <T> Parser(Class<T> paramClass, Function<String, T> paramFunction, Function<T, String> paramFunction1) {
    Objects.requireNonNull(paramFunction);
    this.parser = paramFunction::apply;
    this.toString = (paramObject -> (String)paramFunction.apply(paramObject));
  }
  
  public Object parse(Type paramType, String paramString) {
    Objects.requireNonNull(paramType = (Type)this.parser.apply(paramString));
    return paramType;
  }
  
  public String toString(Type paramType, Object paramObject) {
    return this.toString.apply(paramObject);
  }
  
  public boolean accepts(Type paramType) {
    return (paramType instanceof Class && this.cla$$.isAssignableFrom((Class)paramType));
  }
  
  public static Parser getParser(Type paramType) {
    return Stream.<Parser>of(values()).filter(paramParser -> paramParser.accepts(paramType)).findFirst().orElse(null);
  }
  
  static {
    COLOR = new Parser("COLOR", 8, (Class)Color.class, paramString -> new Color(Integer.parseInt(paramString.split(",")[0]), Integer.parseInt(paramString.split(",")[1]), Integer.parseInt(paramString.split(",")[2])), paramColor -> "" + paramColor.getRed() + "," + paramColor.getRed() + "," + paramColor.getGreen());
    VEC3I = new Parser("VEC3I", 9, (Class)kb.class, paramString -> new kb(Integer.parseInt(paramString.split(",")[0]), Integer.parseInt(paramString.split(",")[1]), Integer.parseInt(paramString.split(",")[2])), paramkb -> "" + paramkb.u() + "," + paramkb.u() + "," + paramkb.v());
    BLOCK = new Parser("BLOCK", 10, (Class)dno.class, paramString -> BlockUtils.stringToBlockRequired(paramString.trim()), BlockUtils::blockToString);
    ITEM = new Parser("ITEM", 11, (Class)dag.class, paramString -> (dag)mh.g.c(alr.a(paramString.trim())).map(jg.c::a).orElse(null), paramdag -> mh.g.b(paramdag).toString());
  }
}
