package baritone.api.utils;

package .tmp;

import azz;
import baritone.api.BaritoneAPI;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import bxe;
import djn;
import ffy;
import fga;
import fgc;
import fgt;
import fgw;
import gqm;
import iw;
import java.util.Optional;
import jc;

public final class RotationUtils {
  public static final double DEG_TO_RAD = 0.017453292519943295D;
  
  public static final float DEG_TO_RAD_F = 0.017453292F;
  
  public static final double RAD_TO_DEG = 57.29577951308232D;
  
  public static final float RAD_TO_DEG_F = 57.29578F;
  
  private static final fgc[] BLOCK_SIDE_MULTIPLIERS = new fgc[] { new fgc(0.5D, 0.0D, 0.5D), new fgc(0.5D, 1.0D, 0.5D), new fgc(0.5D, 0.5D, 0.0D), new fgc(0.5D, 0.5D, 1.0D), new fgc(0.0D, 0.5D, 0.5D), new fgc(1.0D, 0.5D, 0.5D) };
  
  public static Rotation calcRotationFromCoords(iw paramiw1, iw paramiw2) {
    return calcRotationFromVec3d(new fgc(paramiw1.u(), paramiw1.v(), paramiw1.w()), new fgc(paramiw2.u(), paramiw2.v(), paramiw2.w()));
  }
  
  public static Rotation wrapAnglesToRelative(Rotation paramRotation1, Rotation paramRotation2) {
    return paramRotation1.yawIsReallyClose(paramRotation2) ? new Rotation(paramRotation1.getYaw(), paramRotation2.getPitch()) : paramRotation2.subtract(paramRotation1).normalize().add(paramRotation1);
  }
  
  public static Rotation calcRotationFromVec3d(fgc paramfgc1, fgc paramfgc2, Rotation paramRotation) {
    return wrapAnglesToRelative(paramRotation, calcRotationFromVec3d(paramfgc1, paramfgc2));
  }
  
  private static Rotation calcRotationFromVec3d(fgc paramfgc1, fgc paramfgc2) {
    double[] arrayOfDouble;
    double d1 = azz.d((arrayOfDouble = new double[] { paramfgc1.d - paramfgc2.d, paramfgc1.e - paramfgc2.e, paramfgc1.f - paramfgc2.f }, )[0], -arrayOfDouble[2]);
    double d2 = Math.sqrt(arrayOfDouble[0] * arrayOfDouble[0] + arrayOfDouble[2] * arrayOfDouble[2]);
    double d3 = azz.d(arrayOfDouble[1], d2);
    return new Rotation((float)(d1 * 57.29577951308232D), (float)(d3 * 57.29577951308232D));
  }
  
  public static fgc calcLookDirectionFromRotation(Rotation paramRotation) {
    float f2 = azz.b(-paramRotation.getYaw() * 0.017453292F - 3.1415927F);
    float f3 = azz.a(-paramRotation.getYaw() * 0.017453292F - 3.1415927F);
    float f4 = -azz.b(-paramRotation.getPitch() * 0.017453292F);
    float f1 = azz.a(-paramRotation.getPitch() * 0.017453292F);
    return new fgc((f3 * f4), f1, (f2 * f4));
  }
  
  @Deprecated
  public static fgc calcVec3dFromRotation(Rotation paramRotation) {
    return calcLookDirectionFromRotation(paramRotation);
  }
  
  public static Optional<Rotation> reachable(IPlayerContext paramIPlayerContext, iw paramiw) {
    return reachable(paramIPlayerContext, paramiw, false);
  }
  
  public static Optional<Rotation> reachable(IPlayerContext paramIPlayerContext, iw paramiw, boolean paramBoolean) {
    return reachable(paramIPlayerContext, paramiw, paramIPlayerContext.playerController().getBlockReachDistance(), paramBoolean);
  }
  
  public static Optional<Rotation> reachable(IPlayerContext paramIPlayerContext, iw paramiw, double paramDouble) {
    return reachable(paramIPlayerContext, paramiw, paramDouble, false);
  }
  
  public static Optional<Rotation> reachable(IPlayerContext paramIPlayerContext, iw paramiw, double paramDouble, boolean paramBoolean) {
    if (((Boolean)(BaritoneAPI.getSettings()).remainWithExistingLookDirection.value).booleanValue() && paramIPlayerContext.isLookingAt(paramiw)) {
      Rotation rotation = paramIPlayerContext.playerRotations().add(new Rotation(0.0F, 1.0E-4F));
      if (paramBoolean) {
        fga fga;
        if ((fga = RayTraceUtils.rayTraceTowards((bxe)paramIPlayerContext.player(), rotation, paramDouble, true)) != null && fga.d() == fga.a.b && ((ffy)fga).b().equals(paramiw))
          return Optional.of(rotation); 
      } else {
        return Optional.of(rotation);
      } 
    } 
    Optional<Rotation> optional;
    if ((optional = reachableCenter(paramIPlayerContext, paramiw, paramDouble, paramBoolean)).isPresent())
      return optional; 
    fgw fgw;
    if ((fgw = paramIPlayerContext.world().a_(paramiw).f((djn)paramIPlayerContext.world(), paramiw)).c())
      fgw = fgt.b(); 
    fgc[] arrayOfFgc;
    int i = (arrayOfFgc = BLOCK_SIDE_MULTIPLIERS).length;
    for (byte b = 0; b < i; b++) {
      fgc fgc1 = arrayOfFgc[b];
      double d1 = fgw.b(jc.a.a) * fgc1.d + fgw.c(jc.a.a) * (1.0D - fgc1.d);
      double d2 = fgw.b(jc.a.b) * fgc1.e + fgw.c(jc.a.b) * (1.0D - fgc1.e);
      double d3 = fgw.b(jc.a.c) * fgc1.f + fgw.c(jc.a.c) * (1.0D - fgc1.f);
      Optional<Rotation> optional1;
      if ((optional1 = reachableOffset(paramIPlayerContext, paramiw, (new fgc(paramiw.u(), paramiw.v(), paramiw.w())).b(d1, d2, d3), paramDouble, paramBoolean)).isPresent())
        return optional1; 
    } 
    return Optional.empty();
  }
  
  public static Optional<Rotation> reachableOffset(IPlayerContext paramIPlayerContext, iw paramiw, fgc paramfgc, double paramDouble, boolean paramBoolean) {
    Rotation rotation1 = calcRotationFromVec3d(paramBoolean ? RayTraceUtils.inferSneakingEyePosition((bxe)paramIPlayerContext.player()) : paramIPlayerContext.player().n(1.0F), paramfgc, paramIPlayerContext.playerRotations());
    Rotation rotation2 = BaritoneAPI.getProvider().getBaritoneForPlayer(paramIPlayerContext.player()).getLookBehavior().getAimProcessor().peekRotation(rotation1);
    fga fga;
    if ((fga = RayTraceUtils.rayTraceTowards((bxe)paramIPlayerContext.player(), rotation2, paramDouble, paramBoolean)) != null && fga.d() == fga.a.b) {
      if (((ffy)fga).b().equals(paramiw))
        return Optional.of(rotation1); 
      if (paramIPlayerContext.world().a_(paramiw).b() instanceof dnb && ((ffy)fga).b().equals(paramiw.e()))
        return Optional.of(rotation1); 
    } 
    return Optional.empty();
  }
  
  public static Optional<Rotation> reachableCenter(IPlayerContext paramIPlayerContext, iw paramiw, double paramDouble, boolean paramBoolean) {
    return reachableOffset(paramIPlayerContext, paramiw, VecUtils.calculateBlockCenter(paramIPlayerContext.world(), paramiw), paramDouble, paramBoolean);
  }
  
  @Deprecated
  public static Optional<Rotation> reachable(gqm paramgqm, iw paramiw, double paramDouble) {
    return reachable(paramgqm, paramiw, paramDouble, false);
  }
  
  @Deprecated
  public static Optional<Rotation> reachable(gqm paramgqm, iw paramiw, double paramDouble, boolean paramBoolean) {
    return reachable(BaritoneAPI.getProvider().getBaritoneForPlayer(paramgqm).getPlayerContext(), paramiw, paramDouble, paramBoolean);
  }
  
  @Deprecated
  public static Optional<Rotation> reachableOffset(bxe parambxe, iw paramiw, fgc paramfgc, double paramDouble, boolean paramBoolean) {
    Rotation rotation = calcRotationFromVec3d(paramBoolean ? RayTraceUtils.inferSneakingEyePosition(parambxe) : parambxe.n(1.0F), paramfgc, new Rotation(parambxe.dL(), parambxe.dN()));
    fga fga;
    if ((fga = RayTraceUtils.rayTraceTowards(parambxe, rotation, paramDouble, paramBoolean)) != null && fga.d() == fga.a.b) {
      if (((ffy)fga).b().equals(paramiw))
        return Optional.of(rotation); 
      if (parambxe.dV().a_(paramiw).b() instanceof dnb && ((ffy)fga).b().equals(paramiw.e()))
        return Optional.of(rotation); 
    } 
    return Optional.empty();
  }
  
  @Deprecated
  public static Optional<Rotation> reachableCenter(bxe parambxe, iw paramiw, double paramDouble, boolean paramBoolean) {
    return reachableOffset(parambxe, paramiw, VecUtils.calculateBlockCenter(parambxe.dV(), paramiw), paramDouble, paramBoolean);
  }
}
