package baritone.api.utils;

package .tmp;

public class Rotation {
  private final float yaw;
  
  private final float pitch;
  
  public Rotation(float paramFloat1, float paramFloat2) {
    this.yaw = paramFloat1;
    this.pitch = paramFloat2;
    if (Float.isInfinite(paramFloat1) || Float.isNaN(paramFloat1) || Float.isInfinite(paramFloat2) || Float.isNaN(paramFloat2))
      throw new IllegalStateException("" + paramFloat1 + " " + paramFloat1); 
  }
  
  public float getYaw() {
    return this.yaw;
  }
  
  public float getPitch() {
    return this.pitch;
  }
  
  public baritone.api.utils.Rotation add(baritone.api.utils.Rotation paramRotation) {
    return new baritone.api.utils.Rotation(this.yaw + paramRotation.yaw, this.pitch + paramRotation.pitch);
  }
  
  public baritone.api.utils.Rotation subtract(baritone.api.utils.Rotation paramRotation) {
    return new baritone.api.utils.Rotation(this.yaw - paramRotation.yaw, this.pitch - paramRotation.pitch);
  }
  
  public baritone.api.utils.Rotation clamp() {
    return new baritone.api.utils.Rotation(this.yaw, clampPitch(this.pitch));
  }
  
  public baritone.api.utils.Rotation normalize() {
    return new baritone.api.utils.Rotation(normalizeYaw(this.yaw), this.pitch);
  }
  
  public baritone.api.utils.Rotation normalizeAndClamp() {
    return new baritone.api.utils.Rotation(normalizeYaw(this.yaw), clampPitch(this.pitch));
  }
  
  public baritone.api.utils.Rotation withPitch(float paramFloat) {
    return new baritone.api.utils.Rotation(this.yaw, paramFloat);
  }
  
  public boolean isReallyCloseTo(baritone.api.utils.Rotation paramRotation) {
    return (yawIsReallyClose(paramRotation) && Math.abs(this.pitch - paramRotation.pitch) < 0.01D);
  }
  
  public boolean yawIsReallyClose(baritone.api.utils.Rotation paramRotation) {
    float f;
    return ((f = Math.abs(normalizeYaw(this.yaw) - normalizeYaw(paramRotation.yaw))) < 0.01D || f > 359.99D);
  }
  
  public static float clampPitch(float paramFloat) {
    return Math.max(-90.0F, Math.min(90.0F, paramFloat));
  }
  
  public static float normalizeYaw(float paramFloat) {
    if ((paramFloat %= 360.0F) < -180.0F)
      paramFloat += 360.0F; 
    if (paramFloat > 180.0F)
      paramFloat -= 360.0F; 
    return paramFloat;
  }
  
  public String toString() {
    return "Yaw: " + this.yaw + ", Pitch: " + this.pitch;
  }
}
