package baritone.api.utils;

package .tmp;

import baritone.api.pathing.calc.IPath;
import java.util.Objects;
import java.util.Optional;

public class PathCalculationResult {
  private final IPath path;
  
  private final Type type;
  
  public PathCalculationResult(Type paramType) {
    this(paramType, null);
  }
  
  public PathCalculationResult(Type paramType, IPath paramIPath) {
    Objects.requireNonNull(paramType);
    this.path = paramIPath;
    this.type = paramType;
  }
  
  public final Optional<IPath> getPath() {
    return Optional.ofNullable(this.path);
  }
  
  public final Type getType() {
    return this.type;
  }
}
