package baritone.api.utils;

package .tmp;

import java.util.Objects;

public final class Pair<A, B> {
  private final A a;
  
  private final B b;
  
  public Pair(A paramA, B paramB) {
    this.a = paramA;
    this.b = paramB;
  }
  
  public final A first() {
    return this.a;
  }
  
  public final B second() {
    return this.b;
  }
  
  public final boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || paramObject.getClass() != baritone.api.utils.Pair.class)
      return false; 
    paramObject = paramObject;
    return (Objects.equals(this.a, ((baritone.api.utils.Pair)paramObject).a) && Objects.equals(this.b, ((baritone.api.utils.Pair)paramObject).b));
  }
  
  public final int hashCode() {
    return 31 * Objects.hashCode(this.a) + Objects.hashCode(this.b);
  }
}
