package baritone.api.utils;

package .tmp;

import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;

public class NotificationHelper {
  private static TrayIcon trayIcon;
  
  public static void notify(String paramString, boolean paramBoolean) {
    if (SystemUtils.IS_OS_WINDOWS) {
      windows(paramString, paramBoolean);
      return;
    } 
    if (SystemUtils.IS_OS_MAC_OSX) {
      mac(paramString);
      return;
    } 
    if (SystemUtils.IS_OS_LINUX)
      linux(paramString); 
  }
  
  private static void windows(String paramString, boolean paramBoolean) {
    if (SystemTray.isSupported())
      try {
        if (trayIcon == null) {
          SystemTray systemTray = SystemTray.getSystemTray();
          Image image = Toolkit.getDefaultToolkit().createImage("");
          (trayIcon = new TrayIcon(image, "Baritone")).setImageAutoSize(true);
          trayIcon.setToolTip("Baritone");
          systemTray.add(trayIcon);
        } 
        trayIcon.displayMessage("Baritone", paramString, paramBoolean ? TrayIcon.MessageType.ERROR : TrayIcon.MessageType.INFO);
        return;
      } catch (Exception exception) {
        null.printStackTrace();
        return;
      }  
    System.out.println("SystemTray is not supported");
  }
  
  private static void mac(String paramString) {
    ProcessBuilder processBuilder;
    (processBuilder = new ProcessBuilder(new String[0])).command(new String[] { "osascript", "-e", "display notification \"" + paramString + "\" with title \"Baritone\"" });
    try {
      processBuilder.start();
      return;
    } catch (IOException iOException) {
      null.printStackTrace();
      return;
    } 
  }
  
  private static void linux(String paramString) {
    ProcessBuilder processBuilder;
    (processBuilder = new ProcessBuilder(new String[0])).command(new String[] { "notify-send", "-a", "Baritone", paramString });
    try {
      processBuilder.start();
      return;
    } catch (IOException iOException) {
      null.printStackTrace();
      return;
    } 
  }
}
