package baritone.api.utils;

package .tmp;

import baritone.api.cache.IWorldData;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.IPlayerController;
import baritone.api.utils.Rotation;
import bxe;
import dkj;
import ffy;
import fga;
import fgc;
import fqq;
import glo;
import gqm;
import iw;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IPlayerContext {
  fqq minecraft();
  
  gqm player();
  
  IPlayerController playerController();
  
  dkj world();
  
  default Iterable<bxe> entities() {
    return ((glo)world()).d();
  }
  
  default Stream<bxe> entitiesStream() {
    return StreamSupport.stream(entities().spliterator(), false);
  }
  
  IWorldData worldData();
  
  fga objectMouseOver();
  
  default BetterBlockPos playerFeet() {
    BetterBlockPos betterBlockPos = new BetterBlockPos((player().dt()).d, (player().dt()).e + 0.1251D, (player().dt()).f);
    try {
      if (world().a_((iw)betterBlockPos).b() instanceof dvb)
        return betterBlockPos.above(); 
    } catch (NullPointerException nullPointerException) {}
    return betterBlockPos;
  }
  
  default fgc playerFeetAsVec() {
    return new fgc((player().dt()).d, (player().dt()).e, (player().dt()).f);
  }
  
  default fgc playerHead() {
    return new fgc((player().dt()).d, (player().dt()).e + player().cS(), (player().dt()).f);
  }
  
  default fgc playerMotion() {
    return player().dy();
  }
  
  BetterBlockPos viewerPos();
  
  default Rotation playerRotations() {
    return new Rotation(player().dL(), player().dN());
  }
  
  @Deprecated
  static double eyeHeight(boolean paramBoolean) {
    return paramBoolean ? 1.27D : 1.62D;
  }
  
  default Optional<iw> getSelectedBlock() {
    fga fga;
    return ((fga = objectMouseOver()) != null && fga.d() == fga.a.b) ? Optional.of(((ffy)fga).b()) : Optional.empty();
  }
  
  default boolean isLookingAt(iw paramiw) {
    return getSelectedBlock().equals(Optional.of(paramiw));
  }
}
