package baritone.api.utils;

package .tmp;

import baritone.api.utils.BooleanBinaryOperator;

public enum BooleanBinaryOperators implements BooleanBinaryOperator {
  OR, AND, XOR;
  
  private final BooleanBinaryOperator op;
  
  BooleanBinaryOperators(BooleanBinaryOperator paramBooleanBinaryOperator) {
    this.op = paramBooleanBinaryOperator;
  }
  
  public final boolean applyAsBoolean(boolean paramBoolean1, boolean paramBoolean2) {
    return this.op.applyAsBoolean(paramBoolean1, paramBoolean2);
  }
  
  static {
    OR = new baritone.api.utils.BooleanBinaryOperators("OR", 0, (paramBoolean1, paramBoolean2) -> (paramBoolean1 || paramBoolean2));
    AND = new baritone.api.utils.BooleanBinaryOperators("AND", 1, (paramBoolean1, paramBoolean2) -> (paramBoolean1 && paramBoolean2));
    XOR = new baritone.api.utils.BooleanBinaryOperators("XOR", 2, (paramBoolean1, paramBoolean2) -> paramBoolean1 ^ paramBoolean2);
  }
}
