package baritone.api.utils;

package .tmp;

import alr;
import dno;
import java.util.HashMap;
import java.util.Map;
import mh;

public class BlockUtils {
  private static transient Map<String, dno> resourceCache = new HashMap<>();
  
  public static String blockToString(dno paramdno) {
    alr alr;
    String str = (alr = mh.e.b(paramdno)).a();
    if (!alr.b().equals("minecraft"))
      str = alr.toString(); 
    return str;
  }
  
  public static dno stringToBlockRequired(String paramString) {
    dno dno;
    if ((dno = stringToBlockNullable(paramString)) == null)
      throw new IllegalArgumentException(String.format("Invalid block name %s", new Object[] { paramString })); 
    return dno;
  }
  
  public static dno stringToBlockNullable(String paramString) {
    dno dno;
    if ((dno = resourceCache.get(paramString)) != null)
      return dno; 
    if (resourceCache.containsKey(paramString))
      return null; 
    dno = mh.e.b(alr.c(paramString.contains(":") ? paramString : ("minecraft:" + paramString))).orElse(null);
    HashMap<String, dno> hashMap;
    (hashMap = new HashMap<>(resourceCache)).put(paramString, dno);
    resourceCache = hashMap;
    return dno;
  }
}
