package baritone.api.utils;

package .tmp;

import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import dak;
import dno;
import ebq;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class BlockOptionalMetaLookup {
  private final ImmutableSet<dno> blockSet;
  
  private final ImmutableSet<ebq> blockStateSet;
  
  private final ImmutableSet<Integer> stackHashes;
  
  private final BlockOptionalMeta[] boms;
  
  public BlockOptionalMetaLookup(BlockOptionalMeta... paramVarArgs) {
    this.boms = paramVarArgs;
    HashSet<dno> hashSet = new HashSet();
    HashSet<? extends ebq> hashSet1 = new HashSet();
    HashSet<? extends Integer> hashSet2 = new HashSet();
    int i = paramVarArgs.length;
    for (byte b = 0; b < i; b++) {
      BlockOptionalMeta blockOptionalMeta = paramVarArgs[b];
      hashSet.add(blockOptionalMeta.getBlock());
      hashSet1.addAll(blockOptionalMeta.getAllBlockStates());
      hashSet2.addAll(blockOptionalMeta.stackHashes());
    } 
    this.blockSet = ImmutableSet.copyOf(hashSet);
    this.blockStateSet = ImmutableSet.copyOf(hashSet1);
    this.stackHashes = ImmutableSet.copyOf(hashSet2);
  }
  
  public BlockOptionalMetaLookup(dno... paramVarArgs) {
    this((BlockOptionalMeta[])Stream.<dno>of(paramVarArgs).map(BlockOptionalMeta::new).toArray(paramInt -> new BlockOptionalMeta[paramInt]));
  }
  
  public BlockOptionalMetaLookup(List<dno> paramList) {
    this((BlockOptionalMeta[])paramList.stream().map(BlockOptionalMeta::new).toArray(paramInt -> new BlockOptionalMeta[paramInt]));
  }
  
  public BlockOptionalMetaLookup(String... paramVarArgs) {
    this((BlockOptionalMeta[])Stream.<String>of(paramVarArgs).map(BlockOptionalMeta::new).toArray(paramInt -> new BlockOptionalMeta[paramInt]));
  }
  
  public boolean has(dno paramdno) {
    return this.blockSet.contains(paramdno);
  }
  
  public boolean has(ebq paramebq) {
    return this.blockStateSet.contains(paramebq);
  }
  
  public boolean has(dak paramdak) {
    int i = ((IItemStack)paramdak).getBaritoneHash() - paramdak.o();
    return this.stackHashes.contains(Integer.valueOf(i));
  }
  
  public List<BlockOptionalMeta> blocks() {
    return Arrays.asList(this.boms);
  }
  
  public String toString() {
    return String.format("BlockOptionalMetaLookup{%s}", new Object[] { Arrays.toString((Object[])this.boms) });
  }
}
