package baritone.api.utils;

package .tmp;

import alq;
import asb;
import aue;
import avc;
import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import baritone.api.utils.accessor.ILootTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dag;
import dak;
import dao;
import dki;
import dno;
import ebq;
import ebs;
import ect;
import fat;
import faw;
import fdm;
import fdn;
import fgc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class BlockOptionalMeta {
  private static final Pattern PATTERN = Pattern.compile("^(?<id>.+?)(?:\\[(?<properties>.+?)?\\])?$");
  
  private final dno block;
  
  private final String propertiesDescription;
  
  private final Set<ebq> blockstates;
  
  private final ImmutableSet<Integer> stateHashes;
  
  private final ImmutableSet<Integer> stackHashes;
  
  private static Map<dno, List<dag>> drops = new HashMap<>();
  
  private static Method getVanillaServerPack;
  
  public BlockOptionalMeta(@Nonnull dno paramdno) {
    this.block = paramdno;
    this.propertiesDescription = "{}";
    this.blockstates = getStates(paramdno, Collections.emptyMap());
    this.stateHashes = getStateHashes(this.blockstates);
    this.stackHashes = getStackHashes(this.blockstates);
  }
  
  public BlockOptionalMeta(@Nonnull String paramString) {
    Matcher matcher;
    if (!(matcher = PATTERN.matcher(paramString)).find())
      throw new IllegalArgumentException("invalid block selector"); 
    this.block = BlockUtils.stringToBlockRequired(matcher.group("id"));
    String str;
    Map map = (Map)(((str = matcher.group("properties")) == null || str.equals("")) ? Collections.emptyMap() : parseProperties(this.block, str));
    this.propertiesDescription = (str == null) ? "{}" : ("{" + str.replace("=", ":") + "}");
    this.blockstates = getStates(this.block, map);
    this.stateHashes = getStateHashes(this.blockstates);
    this.stackHashes = getStackHashes(this.blockstates);
  }
  
  private static <C extends Comparable<C>, P extends ect<C>> P castToIProperty(Object paramObject) {
    return (P)paramObject;
  }
  
  private static Map<ect<?>, ?> parseProperties(dno paramdno, String paramString) {
    ImmutableMap.Builder<?, ?> builder = ImmutableMap.builder();
    String[] arrayOfString;
    int i = (arrayOfString = paramString.split(",")).length;
    for (byte b = 0; b < i; b++) {
      String str1;
      String[] arrayOfString1;
      if ((arrayOfString1 = (str1 = arrayOfString[b]).split("=")).length != 2)
        throw new IllegalArgumentException(String.format("\"%s\" is not a valid property-value pair", new Object[] { str1 })); 
      str1 = arrayOfString1[0];
      String str2 = arrayOfString1[1];
      ect ect;
      Comparable comparable = (Comparable)castToIProperty(ect = paramdno.l().a(str1)).b(str2).orElseThrow(() -> new IllegalArgumentException(String.format("\"%s\" is not a valid value for %s on %s", new Object[] { paramString, paramect, paramdno })));
      builder.put(ect, comparable);
    } 
    return (Map)builder.build();
  }
  
  private static Set<ebq> getStates(@Nonnull dno paramdno, @Nonnull Map<ect<?>, ?> paramMap) {
    return (Set<ebq>)paramdno.l().a().stream().filter(paramebq -> paramMap.entrySet().stream().allMatch(())).collect(Collectors.toSet());
  }
  
  private static ImmutableSet<Integer> getStateHashes(Set<ebq> paramSet) {
    return ImmutableSet.copyOf((Integer[])paramSet.stream().map(ebs::hashCode).toArray(paramInt -> new Integer[paramInt]));
  }
  
  private static ImmutableSet<Integer> getStackHashes(Set<ebq> paramSet) {
    return ImmutableSet.copyOf((Integer[])paramSet.stream().flatMap(paramebq -> drops(paramebq.b()).stream().map(())).map(paramdak -> Integer.valueOf(((IItemStack)paramdak).getBaritoneHash())).toArray(paramInt -> new Integer[paramInt]));
  }
  
  public final dno getBlock() {
    return this.block;
  }
  
  public final boolean matches(@Nonnull dno paramdno) {
    return (paramdno == this.block);
  }
  
  public final boolean matches(@Nonnull ebq paramebq) {
    return (paramebq.b() == this.block && this.stateHashes.contains(Integer.valueOf(paramebq.hashCode())));
  }
  
  public final boolean matches(dak paramdak) {
    int i = ((IItemStack)paramdak).getBaritoneHash() - paramdak.o();
    return this.stackHashes.contains(Integer.valueOf(i));
  }
  
  public final String toString() {
    return String.format("BlockOptionalMeta{block=%s,properties=%s}", new Object[] { this.block, this.propertiesDescription });
  }
  
  public final ebq getAnyBlockState() {
    return (this.blockstates.size() > 0) ? this.blockstates.iterator().next() : null;
  }
  
  public final Set<ebq> getAllBlockStates() {
    return this.blockstates;
  }
  
  public final Set<Integer> stackHashes() {
    return this.stackHashes;
  }
  
  private static aue getVanillaServerPack() {
    if (getVanillaServerPack == null)
      (getVanillaServerPack = Arrays.stream(avc.class.getDeclaredMethods()).filter(paramMethod -> (paramMethod.getReturnType() == aue.class)).findFirst().orElseThrow()).setAccessible(true); 
    try {
      return (aue)getVanillaServerPack.invoke(null, new Object[0]);
    } catch (Exception exception) {
      null.printStackTrace();
      return null;
    } 
  }
  
  private static synchronized List<dag> drops(dno paramdno) {
    return drops.computeIfAbsent(paramdno, paramdno2 -> {
          if (paramdno2.u().isEmpty())
            return Collections.emptyList(); 
          ArrayList arrayList = new ArrayList();
          try {
            ServerLevelStub serverLevelStub = ServerLevelStub.fastCreate();
            faw.a a = (new faw.a((asb)serverLevelStub)).a(fdn.f, fgc.c).a(fdn.g, paramdno1.m()).a(fdn.i, new dak((dki)dao.qb, 1));
            Objects.requireNonNull(arrayList);
            getDrops(paramdno2, a).stream().map(dak::h).forEach(arrayList::add);
          } catch (Exception exception) {
            null.printStackTrace();
          } 
          return arrayList;
        });
  }
  
  private static List<dak> getDrops(dno paramdno, faw.a parama) {
    faw faw;
    Optional<?> optional;
    return (List<dak>)((optional = paramdno.u()).isEmpty() ? Collections.emptyList() : ((ILootTable)((ServerLevelStub)(faw = parama.a(fdn.g, paramdno.m()).a(fdm.r)).a()).holder().b((alq)optional.get())).invokeGetRandomItems((new fat.a(faw)).a(1L).a(null)));
  }
}
