package baritone.api.utils;

package .tmp;

import azz;
import baritone.api.utils.SettingsUtil;
import iw;
import javax.annotation.Nonnull;
import jc;
import kb;

public final class BetterBlockPos extends iw {
  private static final int NUM_X_BITS = 26;
  
  private static final int NUM_Z_BITS = 26;
  
  private static final int NUM_Y_BITS = 12;
  
  private static final int Y_SHIFT = 26;
  
  private static final int X_SHIFT = 38;
  
  private static final long X_MASK = 67108863L;
  
  private static final long Y_MASK = 4095L;
  
  private static final long Z_MASK = 67108863L;
  
  public static final baritone.api.utils.BetterBlockPos ORIGIN = new baritone.api.utils.BetterBlockPos(0, 0, 0);
  
  public final int x;
  
  public final int y;
  
  public final int z;
  
  public BetterBlockPos(int paramInt1, int paramInt2, int paramInt3) {
    super(paramInt1, paramInt2, paramInt3);
    this.x = paramInt1;
    this.y = paramInt2;
    this.z = paramInt3;
  }
  
  public BetterBlockPos(double paramDouble1, double paramDouble2, double paramDouble3) {
    this(azz.a(paramDouble1), azz.a(paramDouble2), azz.a(paramDouble3));
  }
  
  public BetterBlockPos(iw paramiw) {
    this(paramiw.u(), paramiw.v(), paramiw.w());
  }
  
  public static baritone.api.utils.BetterBlockPos from(iw paramiw) {
    return (paramiw == null) ? null : new baritone.api.utils.BetterBlockPos(paramiw);
  }
  
  public final int hashCode() {
    return (int)longHash(this.x, this.y, this.z);
  }
  
  public static long longHash(baritone.api.utils.BetterBlockPos paramBetterBlockPos) {
    return longHash(paramBetterBlockPos.x, paramBetterBlockPos.y, paramBetterBlockPos.z);
  }
  
  public static long longHash(int paramInt1, int paramInt2, int paramInt3) {
    long l = 11206370049L + paramInt1;
    l = 8734625L * l + paramInt2;
    return 2873465L * l + paramInt3;
  }
  
  public final boolean equals(Object paramObject) {
    return (paramObject == null) ? false : ((paramObject instanceof baritone.api.utils.BetterBlockPos) ? ((((baritone.api.utils.BetterBlockPos)(paramObject = paramObject)).x == this.x && ((baritone.api.utils.BetterBlockPos)paramObject).y == this.y && ((baritone.api.utils.BetterBlockPos)paramObject).z == this.z)) : (((paramObject = paramObject).u() == this.x && paramObject.v() == this.y && paramObject.w() == this.z)));
  }
  
  public final baritone.api.utils.BetterBlockPos above() {
    return new baritone.api.utils.BetterBlockPos(this.x, this.y + 1, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos above(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x, this.y + paramInt, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos below() {
    return new baritone.api.utils.BetterBlockPos(this.x, this.y - 1, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos below(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x, this.y - paramInt, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos relative(jc paramjc) {
    kb kb = paramjc.q();
    return new baritone.api.utils.BetterBlockPos(this.x + kb.u(), this.y + kb.v(), this.z + kb.w());
  }
  
  public final baritone.api.utils.BetterBlockPos relative(jc paramjc, int paramInt) {
    if (paramInt == 0)
      return this; 
    kb kb = paramjc.q();
    return new baritone.api.utils.BetterBlockPos(this.x + kb.u() * paramInt, this.y + kb.v() * paramInt, this.z + kb.w() * paramInt);
  }
  
  public final baritone.api.utils.BetterBlockPos north() {
    return new baritone.api.utils.BetterBlockPos(this.x, this.y, this.z - 1);
  }
  
  public final baritone.api.utils.BetterBlockPos north(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x, this.y, this.z - paramInt);
  }
  
  public final baritone.api.utils.BetterBlockPos south() {
    return new baritone.api.utils.BetterBlockPos(this.x, this.y, this.z + 1);
  }
  
  public final baritone.api.utils.BetterBlockPos south(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x, this.y, this.z + paramInt);
  }
  
  public final baritone.api.utils.BetterBlockPos east() {
    return new baritone.api.utils.BetterBlockPos(this.x + 1, this.y, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos east(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x + paramInt, this.y, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos west() {
    return new baritone.api.utils.BetterBlockPos(this.x - 1, this.y, this.z);
  }
  
  public final baritone.api.utils.BetterBlockPos west(int paramInt) {
    return (paramInt == 0) ? this : new baritone.api.utils.BetterBlockPos(this.x - paramInt, this.y, this.z);
  }
  
  public final double distanceSq(baritone.api.utils.BetterBlockPos paramBetterBlockPos) {
    double d1 = this.x - paramBetterBlockPos.x;
    double d2 = this.y - paramBetterBlockPos.y;
    double d3 = this.z - paramBetterBlockPos.z;
    return d1 * d1 + d2 * d2 + d3 * d3;
  }
  
  public final double distanceTo(baritone.api.utils.BetterBlockPos paramBetterBlockPos) {
    double d1 = this.x - paramBetterBlockPos.x;
    double d2 = this.y - paramBetterBlockPos.y;
    double d3 = this.z - paramBetterBlockPos.z;
    return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
  }
  
  @Nonnull
  public final String toString() {
    return String.format("BetterBlockPos{x=%s,y=%s,z=%s}", new Object[] { SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z) });
  }
  
  public static long serializeToLong(int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt1 & 0x3FFFFFFL) << 38L | (paramInt2 & 0xFFFL) << 26L | paramInt3 & 0x3FFFFFFL;
  }
  
  public static baritone.api.utils.BetterBlockPos deserializeFromLong(long paramLong) {
    int j = (int)(paramLong >> 38L);
    int k = (int)(paramLong << 26L >> 52L);
    int i = (int)(paramLong << 38L >> 38L);
    return new baritone.api.utils.BetterBlockPos(j, k, i);
  }
}
