package baritone.api.schematic.mask.shape;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.schematic.mask.AbstractMask;
import baritone.api.schematic.mask.StaticMask;

public final class SphereMask extends AbstractMask implements StaticMask {
  private final double centerX;
  
  private final double centerY;
  
  private final double centerZ;
  
  private final double radiusSqX;
  
  private final double radiusSqY;
  
  private final double radiusSqZ;
  
  private final boolean filled;
  
  public SphereMask(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean) {
    super(paramInt1, paramInt2, paramInt3);
    this.centerX = paramInt1 / 2.0D;
    this.centerY = paramInt2 / 2.0D;
    this.centerZ = paramInt3 / 2.0D;
    this.radiusSqX = this.centerX * this.centerX;
    this.radiusSqY = this.centerY * this.centerY;
    this.radiusSqZ = this.centerZ * this.centerZ;
    this.filled = paramBoolean;
  }
  
  public final boolean partOfMask(int paramInt1, int paramInt2, int paramInt3) {
    double d1 = Math.abs(paramInt1 + 0.5D - this.centerX);
    double d2 = Math.abs(paramInt2 + 0.5D - this.centerY);
    double d3 = Math.abs(paramInt3 + 0.5D - this.centerZ);
    return outside(d1, d2, d3) ? false : ((this.filled || outside(d1 + 1.0D, d2, d3) || outside(d1, d2 + 1.0D, d3) || outside(d1, d2, d3 + 1.0D)));
  }
  
  private boolean outside(double paramDouble1, double paramDouble2, double paramDouble3) {
    return (paramDouble1 * paramDouble1 / this.radiusSqX + paramDouble2 * paramDouble2 / this.radiusSqY + paramDouble3 * paramDouble3 / this.radiusSqZ > 1.0D);
  }
}
