package baritone.api.schematic.mask.shape;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.schematic.mask.AbstractMask;
import baritone.api.schematic.mask.StaticMask;
import jc;

public final class CylinderMask extends AbstractMask implements StaticMask {
  private final double centerA;
  
  private final double centerB;
  
  private final double radiusSqA;
  
  private final double radiusSqB;
  
  private final boolean filled;
  
  private final jc.a alignment;
  
  public CylinderMask(int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean, jc.a parama) {
    super(paramInt1, paramInt2, paramInt3);
    this.centerA = getA(paramInt1, paramInt2, parama) / 2.0D;
    this.centerB = getB(paramInt2, paramInt3, parama) / 2.0D;
    this.radiusSqA = (this.centerA - 1.0D) * (this.centerA - 1.0D);
    this.radiusSqB = (this.centerB - 1.0D) * (this.centerB - 1.0D);
    this.filled = paramBoolean;
    this.alignment = parama;
  }
  
  public final boolean partOfMask(int paramInt1, int paramInt2, int paramInt3) {
    double d1 = Math.abs(getA(paramInt1, paramInt2, this.alignment) + 0.5D - this.centerA);
    double d2 = Math.abs(getB(paramInt2, paramInt3, this.alignment) + 0.5D - this.centerB);
    return outside(d1, d2) ? false : ((this.filled || outside(d1 + 1.0D, d2) || outside(d1, d2 + 1.0D)));
  }
  
  private boolean outside(double paramDouble1, double paramDouble2) {
    return (paramDouble1 * paramDouble1 / this.radiusSqA + paramDouble2 * paramDouble2 / this.radiusSqB > 1.0D);
  }
  
  private static int getA(int paramInt1, int paramInt2, jc.a parama) {
    return (parama == jc.a.a) ? paramInt2 : paramInt1;
  }
  
  private static int getB(int paramInt1, int paramInt2, jc.a parama) {
    return (parama == jc.a.c) ? paramInt1 : paramInt2;
  }
}
