package baritone.api.schematic.mask.operator;

package .tmp;

import baritone.api.schematic.mask.AbstractMask;
import baritone.api.schematic.mask.Mask;
import baritone.api.utils.BooleanBinaryOperator;
import ebq;

public final class BinaryOperatorMask extends AbstractMask {
  private final Mask a;
  
  private final Mask b;
  
  private final BooleanBinaryOperator operator;
  
  public BinaryOperatorMask(Mask paramMask1, Mask paramMask2, BooleanBinaryOperator paramBooleanBinaryOperator) {
    super(Math.max(paramMask1.widthX(), paramMask2.widthX()), Math.max(paramMask1.heightY(), paramMask2.heightY()), Math.max(paramMask1.lengthZ(), paramMask2.lengthZ()));
    this.a = paramMask1;
    this.b = paramMask2;
    this.operator = paramBooleanBinaryOperator;
  }
  
  public final boolean partOfMask(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    return this.operator.applyAsBoolean(partOfMask(this.a, paramInt1, paramInt2, paramInt3, paramebq), partOfMask(this.b, paramInt1, paramInt2, paramInt3, paramebq));
  }
  
  private static boolean partOfMask(Mask paramMask, int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    return (paramInt1 < paramMask.widthX() && paramInt2 < paramMask.heightY() && paramInt3 < paramMask.lengthZ() && paramMask.partOfMask(paramInt1, paramInt2, paramInt3, paramebq));
  }
}
