package baritone.api.schematic.mask.operator;

package .tmp;

import baritone.api.schematic.mask.AbstractMask;
import baritone.api.schematic.mask.StaticMask;
import baritone.api.schematic.mask.operator.BinaryOperatorMask;
import baritone.api.utils.BooleanBinaryOperator;

public final class Static extends AbstractMask implements StaticMask {
  private final StaticMask a;
  
  private final StaticMask b;
  
  private final BooleanBinaryOperator operator;
  
  public Static(StaticMask paramStaticMask1, StaticMask paramStaticMask2, BooleanBinaryOperator paramBooleanBinaryOperator) {
    super(Math.max(paramStaticMask1.widthX(), paramStaticMask2.widthX()), Math.max(paramStaticMask1.heightY(), paramStaticMask2.heightY()), Math.max(paramStaticMask1.lengthZ(), paramStaticMask2.lengthZ()));
    this.a = paramStaticMask1;
    this.b = paramStaticMask2;
    this.operator = paramBooleanBinaryOperator;
  }
  
  public final boolean partOfMask(int paramInt1, int paramInt2, int paramInt3) {
    return this.operator.applyAsBoolean(partOfMask(this.a, paramInt1, paramInt2, paramInt3), partOfMask(this.b, paramInt1, paramInt2, paramInt3));
  }
  
  private static boolean partOfMask(StaticMask paramStaticMask, int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt1 < paramStaticMask.widthX() && paramInt2 < paramStaticMask.heightY() && paramInt3 < paramStaticMask.lengthZ() && paramStaticMask.partOfMask(paramInt1, paramInt2, paramInt3));
  }
}
