package baritone.api.schematic;

package .tmp;

import baritone.api.schematic.AbstractSchematic;
import baritone.api.schematic.ISchematic;
import dno;
import dnq;
import ebq;
import ect;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubstituteSchematic extends AbstractSchematic {
  private final ISchematic schematic;
  
  private final Map<dno, List<dno>> substitutions;
  
  private final Map<ebq, Map<dno, ebq>> blockStateCache = new HashMap<>();
  
  public SubstituteSchematic(ISchematic paramISchematic, Map<dno, List<dno>> paramMap) {
    super(paramISchematic.widthX(), paramISchematic.heightY(), paramISchematic.lengthZ());
    this.schematic = paramISchematic;
    this.substitutions = paramMap;
  }
  
  public boolean inSchematic(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    return this.schematic.inSchematic(paramInt1, paramInt2, paramInt3, paramebq);
  }
  
  public ebq desiredState(int paramInt1, int paramInt2, int paramInt3, ebq paramebq, List<ebq> paramList) {
    ebq ebq1;
    dno dno = (ebq1 = this.schematic.desiredState(paramInt1, paramInt2, paramInt3, paramebq, paramList)).b();
    if (!this.substitutions.containsKey(dno))
      return ebq1; 
    List<?> list;
    if ((list = this.substitutions.get(dno)).contains(paramebq.b()) && !(paramebq.b() instanceof dml))
      return withBlock(ebq1, paramebq.b()); 
    Iterator<?> iterator = list.iterator();
    while (iterator.hasNext()) {
      dno dno1;
      if (dno1 = (dno)iterator.next() instanceof dml)
        return (paramebq.b() instanceof dml) ? paramebq : dnq.a.m(); 
      for (ebq ebq2 : paramList) {
        if (dno1.equals(ebq2.b()))
          return withBlock(ebq1, ebq2.b()); 
      } 
    } 
    return ((dno)list.get(0)).m();
  }
  
  private ebq withBlock(ebq paramebq, dno paramdno) {
    if (this.blockStateCache.containsKey(paramebq) && ((Map)this.blockStateCache.get(paramebq)).containsKey(paramdno))
      return (ebq)((Map)this.blockStateCache.get(paramebq)).get(paramdno); 
    Collection collection = paramebq.F();
    ebq ebq1 = paramdno.m();
    for (ect<Comparable> ect : (Iterable<ect<Comparable>>)collection) {
      try {
        ebq1 = copySingleProp(paramebq, ebq1, ect);
      } catch (IllegalArgumentException illegalArgumentException) {}
    } 
    ((Map<dno, ebq>)this.blockStateCache.computeIfAbsent(paramebq, paramebq -> new HashMap<>())).put(paramdno, ebq1);
    return ebq1;
  }
  
  private <T extends Comparable<T>> ebq copySingleProp(ebq paramebq1, ebq paramebq2, ect<T> paramect) {
    return (ebq)paramebq2.b(paramect, paramebq1.c(paramect));
  }
}
