package baritone.api.schematic;

package .tmp;

import baritone.api.schematic.ISchematic;
import dui;
import ebq;
import java.util.List;
import java.util.stream.Collectors;

public class RotatedSchematic implements ISchematic {
  private final ISchematic schematic;
  
  private final dui rotation;
  
  private final dui inverseRotation;
  
  public RotatedSchematic(ISchematic paramISchematic, dui paramdui) {
    this.schematic = paramISchematic;
    this.rotation = paramdui;
    this.inverseRotation = paramdui.a(paramdui).a(paramdui);
  }
  
  public boolean inSchematic(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    return this.schematic.inSchematic(rotateX(paramInt1, paramInt3, widthX(), lengthZ(), this.inverseRotation), paramInt2, rotateZ(paramInt1, paramInt3, widthX(), lengthZ(), this.inverseRotation), rotate(paramebq, this.inverseRotation));
  }
  
  public ebq desiredState(int paramInt1, int paramInt2, int paramInt3, ebq paramebq, List<ebq> paramList) {
    return rotate(this.schematic.desiredState(rotateX(paramInt1, paramInt3, widthX(), lengthZ(), this.inverseRotation), paramInt2, rotateZ(paramInt1, paramInt3, widthX(), lengthZ(), this.inverseRotation), rotate(paramebq, this.inverseRotation), rotate(paramList, this.inverseRotation)), this.rotation);
  }
  
  public void reset() {
    this.schematic.reset();
  }
  
  public int widthX() {
    return flipsCoordinates(this.rotation) ? this.schematic.lengthZ() : this.schematic.widthX();
  }
  
  public int heightY() {
    return this.schematic.heightY();
  }
  
  public int lengthZ() {
    return flipsCoordinates(this.rotation) ? this.schematic.widthX() : this.schematic.lengthZ();
  }
  
  private static boolean flipsCoordinates(dui paramdui) {
    return (paramdui == dui.b || paramdui == dui.d);
  }
  
  private static int rotateX(int paramInt1, int paramInt2, int paramInt3, int paramInt4, dui paramdui) {
    switch (null.$SwitchMap$net$minecraft$world$level$block$Rotation[paramdui.ordinal()]) {
      case 1:
        return paramInt1;
      case 2:
        return paramInt4 - paramInt2 - 1;
      case 3:
        return paramInt3 - paramInt1 - 1;
      case 4:
        return paramInt2;
    } 
    throw new IllegalArgumentException("Unknown rotation");
  }
  
  private static int rotateZ(int paramInt1, int paramInt2, int paramInt3, int paramInt4, dui paramdui) {
    switch (null.$SwitchMap$net$minecraft$world$level$block$Rotation[paramdui.ordinal()]) {
      case 1:
        return paramInt2;
      case 2:
        return paramInt1;
      case 3:
        return paramInt4 - paramInt2 - 1;
      case 4:
        return paramInt3 - paramInt1 - 1;
    } 
    throw new IllegalArgumentException("Unknown rotation");
  }
  
  private static ebq rotate(ebq paramebq, dui paramdui) {
    return (paramebq == null) ? null : paramebq.a(paramdui);
  }
  
  private static List<ebq> rotate(List<ebq> paramList, dui paramdui) {
    return (paramList == null) ? null : (List<ebq>)paramList.stream().map(paramebq -> rotate(paramebq, paramdui)).collect(Collectors.toList());
  }
}
