package baritone.api.schematic;

package .tmp;

import baritone.api.schematic.ISchematic;
import baritone.api.schematic.MaskSchematic;
import baritone.api.utils.BlockOptionalMetaLookup;
import ebq;

public class ReplaceSchematic extends MaskSchematic {
  private final BlockOptionalMetaLookup filter;
  
  private final Boolean[][][] cache;
  
  public ReplaceSchematic(ISchematic paramISchematic, BlockOptionalMetaLookup paramBlockOptionalMetaLookup) {
    super(paramISchematic);
    this.filter = paramBlockOptionalMetaLookup;
    this.cache = new Boolean[widthX()][heightY()][lengthZ()];
  }
  
  public void reset() {
    for (byte b = 0; b < this.cache.length; b++) {
      for (byte b1 = 0; b1 < (this.cache[0]).length; b1++) {
        for (byte b2 = 0; b2 < (this.cache[0][0]).length; b2++)
          this.cache[b][b1][b2] = null; 
      } 
    } 
  }
  
  protected boolean partOfMask(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    if (this.cache[paramInt1][paramInt2][paramInt3] == null)
      this.cache[paramInt1][paramInt2][paramInt3] = Boolean.valueOf(this.filter.has(paramebq)); 
    return this.cache[paramInt1][paramInt2][paramInt3].booleanValue();
  }
}
