package baritone.api.schematic;

package .tmp;

import baritone.api.schematic.AbstractSchematic;
import baritone.api.schematic.ISchematic;
import baritone.api.schematic.mask.Mask;
import ebq;
import java.util.List;

public abstract class MaskSchematic extends AbstractSchematic {
  private final ISchematic schematic;
  
  public MaskSchematic(ISchematic paramISchematic) {
    super(paramISchematic.widthX(), paramISchematic.heightY(), paramISchematic.lengthZ());
    this.schematic = paramISchematic;
  }
  
  protected abstract boolean partOfMask(int paramInt1, int paramInt2, int paramInt3, ebq paramebq);
  
  public boolean inSchematic(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    return (this.schematic.inSchematic(paramInt1, paramInt2, paramInt3, paramebq) && partOfMask(paramInt1, paramInt2, paramInt3, paramebq));
  }
  
  public ebq desiredState(int paramInt1, int paramInt2, int paramInt3, ebq paramebq, List<ebq> paramList) {
    return this.schematic.desiredState(paramInt1, paramInt2, paramInt3, paramebq, paramList);
  }
  
  public static baritone.api.schematic.MaskSchematic create(ISchematic paramISchematic, Mask paramMask) {
    return (baritone.api.schematic.MaskSchematic)new Object(paramISchematic, paramMask);
  }
}
