package baritone.api.schematic;

package .tmp;

import baritone.api.schematic.AbstractSchematic;
import baritone.api.schematic.CompositeSchematicEntry;
import baritone.api.schematic.ISchematic;
import ebq;
import java.util.ArrayList;
import java.util.List;

public class CompositeSchematic extends AbstractSchematic {
  private final List<CompositeSchematicEntry> schematics = new ArrayList<>();
  
  private CompositeSchematicEntry[] schematicArr;
  
  private void recalcArr() {
    this.schematicArr = this.schematics.<CompositeSchematicEntry>toArray(new CompositeSchematicEntry[0]);
    CompositeSchematicEntry[] arrayOfCompositeSchematicEntry;
    int i = (arrayOfCompositeSchematicEntry = this.schematicArr).length;
    for (byte b = 0; b < i; b++) {
      CompositeSchematicEntry compositeSchematicEntry = arrayOfCompositeSchematicEntry[b];
      this.x = Math.max(this.x, compositeSchematicEntry.x + compositeSchematicEntry.schematic.widthX());
      this.y = Math.max(this.y, compositeSchematicEntry.y + compositeSchematicEntry.schematic.heightY());
      this.z = Math.max(this.z, compositeSchematicEntry.z + compositeSchematicEntry.schematic.lengthZ());
    } 
  }
  
  public CompositeSchematic(int paramInt1, int paramInt2, int paramInt3) {
    super(paramInt1, paramInt2, paramInt3);
    recalcArr();
  }
  
  public void put(ISchematic paramISchematic, int paramInt1, int paramInt2, int paramInt3) {
    this.schematics.add(new CompositeSchematicEntry(paramISchematic, paramInt1, paramInt2, paramInt3));
    recalcArr();
  }
  
  private CompositeSchematicEntry getSchematic(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    CompositeSchematicEntry[] arrayOfCompositeSchematicEntry;
    int i = (arrayOfCompositeSchematicEntry = this.schematicArr).length;
    for (byte b = 0; b < i; b++) {
      CompositeSchematicEntry compositeSchematicEntry = arrayOfCompositeSchematicEntry[b];
      if (paramInt1 >= compositeSchematicEntry.x && paramInt2 >= compositeSchematicEntry.y && paramInt3 >= compositeSchematicEntry.z && compositeSchematicEntry.schematic.inSchematic(paramInt1 - compositeSchematicEntry.x, paramInt2 - compositeSchematicEntry.y, paramInt3 - compositeSchematicEntry.z, paramebq))
        return compositeSchematicEntry; 
    } 
    return null;
  }
  
  public boolean inSchematic(int paramInt1, int paramInt2, int paramInt3, ebq paramebq) {
    CompositeSchematicEntry compositeSchematicEntry;
    return ((compositeSchematicEntry = getSchematic(paramInt1, paramInt2, paramInt3, paramebq)) != null && compositeSchematicEntry.schematic.inSchematic(paramInt1 - compositeSchematicEntry.x, paramInt2 - compositeSchematicEntry.y, paramInt3 - compositeSchematicEntry.z, paramebq));
  }
  
  public ebq desiredState(int paramInt1, int paramInt2, int paramInt3, ebq paramebq, List<ebq> paramList) {
    CompositeSchematicEntry compositeSchematicEntry;
    if ((compositeSchematicEntry = getSchematic(paramInt1, paramInt2, paramInt3, paramebq)) == null)
      throw new IllegalStateException("couldn't find schematic for this position"); 
    return compositeSchematicEntry.schematic.desiredState(paramInt1 - compositeSchematicEntry.x, paramInt2 - compositeSchematicEntry.y, paramInt3 - compositeSchematicEntry.z, paramebq, paramList);
  }
  
  public void reset() {
    CompositeSchematicEntry[] arrayOfCompositeSchematicEntry;
    int i = (arrayOfCompositeSchematicEntry = this.schematicArr).length;
    for (byte b = 0; b < i; b++)
      (arrayOfCompositeSchematicEntry[b]).schematic.reset(); 
  }
}
