package baritone.api.process;

package .tmp;

import baritone.api.process.IBaritoneProcess;
import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.BlockOptionalMetaLookup;
import dno;
import java.util.function.Function;
import java.util.stream.Stream;

public interface IMineProcess extends IBaritoneProcess {
  void mineByName(int paramInt, String... paramVarArgs);
  
  void mine(int paramInt, BlockOptionalMetaLookup paramBlockOptionalMetaLookup);
  
  default void mine(BlockOptionalMetaLookup paramBlockOptionalMetaLookup) {
    mine(0, paramBlockOptionalMetaLookup);
  }
  
  void mineByName(String... paramVarArgs) {
    mineByName(0, paramVarArgs);
  }
  
  void mine(int paramInt, BlockOptionalMeta... paramVarArgs) {
    mine(paramInt, new BlockOptionalMetaLookup(paramVarArgs));
  }
  
  void mine(BlockOptionalMeta... paramVarArgs) {
    mine(0, paramVarArgs);
  }
  
  void mine(int paramInt, dno... paramVarArgs) {
    mine(paramInt, new BlockOptionalMetaLookup((BlockOptionalMeta[])Stream.<dno>of(paramVarArgs).map(BlockOptionalMeta::new).toArray(paramInt -> new BlockOptionalMeta[paramInt])));
  }
  
  void mine(dno... paramVarArgs) {
    mine(0, paramVarArgs);
  }
  
  default void cancel() {
    onLostControl();
  }
}
