package baritone.api.pathing.movement;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

public interface ActionCosts {
  public static final double WALK_ONE_BLOCK_COST = 4.63284688441047D;
  
  public static final double WALK_ONE_IN_WATER_COST = 9.09090909090909D;
  
  public static final double WALK_ONE_OVER_SOUL_SAND_COST = 9.26569376882094D;
  
  public static final double LADDER_UP_ONE_COST = 8.51063829787234D;
  
  public static final double LADDER_DOWN_ONE_COST = 6.666666666666667D;
  
  public static final double SNEAK_ONE_BLOCK_COST = 15.384615384615383D;
  
  public static final double SPRINT_ONE_BLOCK_COST = 3.563791874554526D;
  
  public static final double SPRINT_MULTIPLIER = 0.7692444761225944D;
  
  public static final double WALK_OFF_BLOCK_COST = 3.7062775075283763D;
  
  public static final double CENTER_AFTER_FALL_COST = 0.9265693768820937D;
  
  public static final double COST_INF = 1000000.0D;
  
  public static final double[] FALL_N_BLOCKS_COST = generateFallNBlocksCost();
  
  public static final double FALL_1_25_BLOCKS_COST = distanceToTicks(1.25D);
  
  public static final double FALL_0_25_BLOCKS_COST = distanceToTicks(0.25D);
  
  public static final double JUMP_ONE_BLOCK_COST = FALL_1_25_BLOCKS_COST - FALL_0_25_BLOCKS_COST;
  
  static double[] generateFallNBlocksCost() {
    double[] arrayOfDouble = new double[4097];
    for (byte b = 0; b < 'ခ'; b++)
      arrayOfDouble[b] = distanceToTicks(b); 
    return arrayOfDouble;
  }
  
  static double velocity(int paramInt) {
    return (Math.pow(0.98D, paramInt) - 1.0D) * -3.92D;
  }
  
  static double oldFormula(double paramDouble) {
    return -3.92D * (99.0D - 49.5D * (Math.pow(0.98D, paramDouble) + 1.0D) - paramDouble);
  }
  
  static double distanceToTicks(double paramDouble) {
    if (paramDouble == 0.0D)
      return 0.0D; 
    double d = paramDouble;
    for (byte b = 0;; b++) {
      double d1 = velocity(b);
      if (d <= d1)
        return b + d / d1; 
      d -= d1;
    } 
  }
}
