package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.movement.ActionCosts;
import baritone.api.utils.SettingsUtil;

public class GoalYLevel implements Goal, ActionCosts {
  public final int level;
  
  public GoalYLevel(int paramInt) {
    this.level = paramInt;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt2 == this.level);
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    return calculate(this.level, paramInt2);
  }
  
  public static double calculate(int paramInt1, int paramInt2) {
    return (paramInt2 > paramInt1) ? (FALL_N_BLOCKS_COST[2] / 2.0D * (paramInt2 - paramInt1)) : ((paramInt2 < paramInt1) ? ((paramInt1 - paramInt2) * JUMP_ONE_BLOCK_COST) : 0.0D);
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.level == ((baritone.api.pathing.goals.GoalYLevel)paramObject).level);
  }
  
  public int hashCode() {
    return this.level * 1271009915;
  }
  
  public String toString() {
    return String.format("GoalYLevel{y=%s}", new Object[] { SettingsUtil.maybeCensor(this.level) });
  }
}
