package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import azz;
import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.SettingsUtil;
import fgc;

public class GoalXZ implements Goal {
  private static final double SQRT_2 = Math.sqrt(2.0D);
  
  private final int x;
  
  private final int z;
  
  public GoalXZ(int paramInt1, int paramInt2) {
    this.x = paramInt1;
    this.z = paramInt2;
  }
  
  public GoalXZ(BetterBlockPos paramBetterBlockPos) {
    this.x = paramBetterBlockPos.x;
    this.z = paramBetterBlockPos.z;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt1 == this.x && paramInt3 == this.z);
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 = paramInt3 - this.z;
    return calculate(paramInt1, paramInt2);
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.x == ((baritone.api.pathing.goals.GoalXZ)paramObject).x && this.z == ((baritone.api.pathing.goals.GoalXZ)paramObject).z);
  }
  
  public int hashCode() {
    return (1204478626 + this.x) * -1331679453 + this.z;
  }
  
  public String toString() {
    return String.format("GoalXZ{x=%s,z=%s}", new Object[] { SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.z) });
  }
  
  public static double calculate(double paramDouble1, double paramDouble2) {
    double d3;
    double d4;
    double d1 = Math.abs(paramDouble1);
    double d2 = Math.abs(paramDouble2);
    if (d1 < d2) {
      d3 = d2 - d1;
      d4 = d1;
    } else {
      d3 = d1 - d2;
      d4 = d2;
    } 
    return (d4 * SQRT_2 + d3) * ((Double)(BaritoneAPI.getSettings()).costHeuristic.value).doubleValue();
  }
  
  public static baritone.api.pathing.goals.GoalXZ fromDirection(fgc paramfgc, float paramFloat, double paramDouble) {
    paramFloat = (float)Math.toRadians(paramFloat);
    double d1 = paramfgc.d - azz.a(paramFloat) * paramDouble;
    double d2 = paramfgc.f + azz.b(paramFloat) * paramDouble;
    return new baritone.api.pathing.goals.GoalXZ(azz.a(d1), azz.a(d2));
  }
  
  public int getX() {
    return this.x;
  }
  
  public int getZ() {
    return this.z;
  }
}
