package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.pathing.goals.GoalYLevel;
import baritone.api.utils.SettingsUtil;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import iw;
import java.util.Arrays;
import java.util.Objects;

public class GoalRunAway implements Goal {
  private final iw[] from;
  
  private final int distanceSq;
  
  private final Integer maintainY;
  
  public GoalRunAway(double paramDouble, iw... paramVarArgs) {
    this(paramDouble, null, paramVarArgs);
  }
  
  public GoalRunAway(double paramDouble, Integer paramInteger, iw... paramVarArgs) {
    if (paramVarArgs.length == 0)
      throw new IllegalArgumentException("Positions to run away from must not be empty"); 
    this.from = paramVarArgs;
    this.distanceSq = (int)(paramDouble * paramDouble);
    this.maintainY = paramInteger;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    if (this.maintainY != null && this.maintainY.intValue() != paramInt2)
      return false; 
    iw[] arrayOfIw;
    int i = (arrayOfIw = this.from).length;
    for (byte b = 0; b < i; b++) {
      iw iw1 = arrayOfIw[b];
      int k = paramInt1 - iw1.u();
      int j = paramInt3 - iw1.w();
      if (k * k + j * j < this.distanceSq)
        return false; 
    } 
    return true;
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    double d = Double.MAX_VALUE;
    iw[] arrayOfIw;
    int i = (arrayOfIw = this.from).length;
    for (byte b = 0; b < i; b++) {
      iw iw1;
      double d1;
      if ((d1 = GoalXZ.calculate(((iw1 = arrayOfIw[b]).u() - paramInt1), (iw1.w() - paramInt3))) < d)
        d = d1; 
    } 
    d = -d;
    if (this.maintainY != null)
      d = d * 0.6D + GoalYLevel.calculate(this.maintainY.intValue(), paramInt2) * 1.5D; 
    return d;
  }
  
  public double heuristic() {
    int i = (int)Math.ceil(Math.sqrt(this.distanceSq));
    int j = Integer.MAX_VALUE;
    int k = Integer.MAX_VALUE;
    int m = Integer.MAX_VALUE;
    int n = Integer.MIN_VALUE;
    int i1 = Integer.MIN_VALUE;
    int i2 = Integer.MIN_VALUE;
    iw[] arrayOfIw;
    int i3 = (arrayOfIw = this.from).length;
    for (byte b = 0; b < i3; b++) {
      iw iw1 = arrayOfIw[b];
      j = Math.min(j, iw1.u() - i);
      k = Math.min(k, iw1.v() - i);
      m = Math.min(m, iw1.w() - i);
      n = Math.max(j, iw1.u() + i);
      i1 = Math.max(k, iw1.v() + i);
      i2 = Math.max(m, iw1.w() + i);
    } 
    DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet();
    double d1 = Double.POSITIVE_INFINITY;
    for (int i4 = j; i4 <= n; i4++) {
      for (int i5 = k; i5 <= i1; i5++) {
        for (i = m; i <= i2; i++) {
          double d;
          if ((d = heuristic(i4, i5, i)) < d1 && isInGoal(i4, i5, i)) {
            doubleOpenHashSet.add(d);
          } else {
            d1 = Math.min(d1, d);
          } 
        } 
      } 
    } 
    double d2 = Double.NEGATIVE_INFINITY;
    DoubleIterator doubleIterator = doubleOpenHashSet.iterator();
    while (doubleIterator.hasNext()) {
      double d;
      if ((d = doubleIterator.nextDouble()) < d1)
        d2 = Math.max(d2, d); 
    } 
    return d2;
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.distanceSq == ((baritone.api.pathing.goals.GoalRunAway)paramObject).distanceSq && Arrays.equals((Object[])this.from, (Object[])((baritone.api.pathing.goals.GoalRunAway)paramObject).from) && Objects.equals(this.maintainY, ((baritone.api.pathing.goals.GoalRunAway)paramObject).maintainY));
  }
  
  public int hashCode() {
    return (Arrays.hashCode((Object[])this.from) * 1196803141 + this.distanceSq) * -2053788840 + this.maintainY.intValue();
  }
  
  public String toString() {
    return (this.maintainY != null) ? String.format("GoalRunAwayFromMaintainY y=%s, %s", new Object[] { SettingsUtil.maybeCensor(this.maintainY.intValue()), Arrays.asList(this.from) }) : ("GoalRunAwayFrom" + String.valueOf(Arrays.asList(this.from)));
  }
}
