package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.interfaces.IGoalRenderPos;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import iw;

public class GoalNear implements Goal, IGoalRenderPos {
  private final int x;
  
  private final int y;
  
  private final int z;
  
  private final int rangeSq;
  
  public GoalNear(iw paramiw, int paramInt) {
    this.x = paramiw.u();
    this.y = paramiw.v();
    this.z = paramiw.w();
    this.rangeSq = paramInt * paramInt;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 -= this.y;
    paramInt3 -= this.z;
    return (paramInt1 * paramInt1 + paramInt2 * paramInt2 + paramInt3 * paramInt3 <= this.rangeSq);
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 -= this.y;
    paramInt3 -= this.z;
    return GoalBlock.calculate(paramInt1, paramInt2, paramInt3);
  }
  
  public double heuristic() {
    int i = (int)Math.ceil(Math.sqrt(this.rangeSq));
    DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet();
    double d1 = Double.POSITIVE_INFINITY;
    for (int j = -i; j <= i; j++) {
      for (int k = -i; k <= i; k++) {
        for (int m = -i; m <= i; m++) {
          double d;
          if ((d = heuristic(this.x + j, this.y + k, this.z + m)) < d1 && isInGoal(this.x + j, this.y + k, this.z + m)) {
            doubleOpenHashSet.add(d);
          } else {
            d1 = Math.min(d1, d);
          } 
        } 
      } 
    } 
    double d2 = Double.NEGATIVE_INFINITY;
    DoubleIterator doubleIterator = doubleOpenHashSet.iterator();
    while (doubleIterator.hasNext()) {
      double d;
      if ((d = doubleIterator.nextDouble()) < d1)
        d2 = Math.max(d2, d); 
    } 
    return d2;
  }
  
  public iw getGoalPos() {
    return new iw(this.x, this.y, this.z);
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.x == ((baritone.api.pathing.goals.GoalNear)paramObject).x && this.y == ((baritone.api.pathing.goals.GoalNear)paramObject).y && this.z == ((baritone.api.pathing.goals.GoalNear)paramObject).z && this.rangeSq == ((baritone.api.pathing.goals.GoalNear)paramObject).rangeSq);
  }
  
  public int hashCode() {
    return (int)BetterBlockPos.longHash(this.x, this.y, this.z) + this.rangeSq;
  }
  
  public String toString() {
    return String.format("GoalNear{x=%s, y=%s, z=%s, rangeSq=%d}", new Object[] { SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z), Integer.valueOf(this.rangeSq) });
  }
}
